/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PreviewStatus {
    WORK_IN_PROGRESS("WORK_IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PreviewStatus> VALUE_MAP;
    private final String value;

    private PreviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PreviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PreviewStatus> knownValues() {
        EnumSet<PreviewStatus> knownValues = EnumSet.allOf(PreviewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PreviewStatus.class, PreviewStatus::toString);
    }
}

