/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse;

public class ListLifecycleExecutionResourcesIterable
implements SdkIterable<ListLifecycleExecutionResourcesResponse> {
    private final ImagebuilderClient client;
    private final ListLifecycleExecutionResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLifecycleExecutionResourcesIterable(ImagebuilderClient client, ListLifecycleExecutionResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLifecycleExecutionResourcesResponseFetcher();
    }

    public Iterator<ListLifecycleExecutionResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LifecycleExecutionResource> resources() {
        Function<ListLifecycleExecutionResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLifecycleExecutionResourcesResponseFetcher
    implements SyncPageFetcher<ListLifecycleExecutionResourcesResponse> {
        private ListLifecycleExecutionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLifecycleExecutionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLifecycleExecutionResourcesResponse nextPage(ListLifecycleExecutionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLifecycleExecutionResourcesIterable.this.client.listLifecycleExecutionResources(ListLifecycleExecutionResourcesIterable.this.firstRequest);
            }
            return ListLifecycleExecutionResourcesIterable.this.client.listLifecycleExecutionResources((ListLifecycleExecutionResourcesRequest)((Object)ListLifecycleExecutionResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

