/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, GetContainerRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(GetContainerRecipeResponse.getter(GetContainerRecipeResponse::requestId)).setter(GetContainerRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<ContainerRecipe> CONTAINER_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerRecipe").getter(GetContainerRecipeResponse.getter(GetContainerRecipeResponse::containerRecipe)).setter(GetContainerRecipeResponse.setter(Builder::containerRecipe)).constructor(ContainerRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CONTAINER_RECIPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("requestId", REQUEST_ID_FIELD);
            this.put("containerRecipe", CONTAINER_RECIPE_FIELD);
        }
    });
    private final String requestIdValue;
    private final ContainerRecipe containerRecipe;

    private GetContainerRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.containerRecipe = builder.containerRecipe;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final ContainerRecipe containerRecipe() {
        return this.containerRecipe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipe());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerRecipeResponse)) {
            return false;
        }
        GetContainerRecipeResponse other = (GetContainerRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.containerRecipe(), other.containerRecipe());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerRecipeResponse").add("RequestId", (Object)this.requestId()).add("ContainerRecipe", (Object)this.containerRecipe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "containerRecipe": {
                return Optional.ofNullable(clazz.cast(this.containerRecipe()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerRecipeResponse, T> g) {
        return obj -> g.apply((GetContainerRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private ContainerRecipe containerRecipe;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.containerRecipe(model.containerRecipe);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final ContainerRecipe.Builder getContainerRecipe() {
            return this.containerRecipe != null ? this.containerRecipe.toBuilder() : null;
        }

        public final void setContainerRecipe(ContainerRecipe.BuilderImpl containerRecipe) {
            this.containerRecipe = containerRecipe != null ? containerRecipe.build() : null;
        }

        @Override
        public final Builder containerRecipe(ContainerRecipe containerRecipe) {
            this.containerRecipe = containerRecipe;
            return this;
        }

        @Override
        public GetContainerRecipeResponse build() {
            return new GetContainerRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerRecipeResponse> {
        public Builder requestId(String var1);

        public Builder containerRecipe(ContainerRecipe var1);

        default public Builder containerRecipe(Consumer<ContainerRecipe.Builder> containerRecipe) {
            return this.containerRecipe((ContainerRecipe)((ContainerRecipe.Builder)ContainerRecipe.builder().applyMutation(containerRecipe)).build());
        }
    }
}

