/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreResponse;
import software.amazon.awssdk.services.identitystore.model.MemberId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupMembershipResponse
extends IdentitystoreResponse
implements ToCopyableBuilder<Builder, DescribeGroupMembershipResponse> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(DescribeGroupMembershipResponse.getter(DescribeGroupMembershipResponse::identityStoreId)).setter(DescribeGroupMembershipResponse.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MembershipId").getter(DescribeGroupMembershipResponse.getter(DescribeGroupMembershipResponse::membershipId)).setter(DescribeGroupMembershipResponse.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DescribeGroupMembershipResponse.getter(DescribeGroupMembershipResponse::groupId)).setter(DescribeGroupMembershipResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberId").getter(DescribeGroupMembershipResponse.getter(DescribeGroupMembershipResponse::memberId)).setter(DescribeGroupMembershipResponse.setter(Builder::memberId)).constructor(MemberId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, MEMBERSHIP_ID_FIELD, GROUP_ID_FIELD, MEMBER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
            this.put("MembershipId", MEMBERSHIP_ID_FIELD);
            this.put("GroupId", GROUP_ID_FIELD);
            this.put("MemberId", MEMBER_ID_FIELD);
        }
    });
    private final String identityStoreId;
    private final String membershipId;
    private final String groupId;
    private final MemberId memberId;

    private DescribeGroupMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.membershipId = builder.membershipId;
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final MemberId memberId() {
        return this.memberId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupMembershipResponse)) {
            return false;
        }
        DescribeGroupMembershipResponse other = (DescribeGroupMembershipResponse)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.memberId(), other.memberId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupMembershipResponse").add("IdentityStoreId", (Object)this.identityStoreId()).add("MembershipId", (Object)this.membershipId()).add("GroupId", (Object)this.groupId()).add("MemberId", (Object)this.memberId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "MembershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupMembershipResponse, T> g) {
        return obj -> g.apply((DescribeGroupMembershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreResponse.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private String membershipId;
        private String groupId;
        private MemberId memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupMembershipResponse model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.membershipId(model.membershipId);
            this.groupId(model.groupId);
            this.memberId(model.memberId);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return this.memberId != null ? this.memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        @Override
        public DescribeGroupMembershipResponse build() {
            return new DescribeGroupMembershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IdentitystoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupMembershipResponse> {
        public Builder identityStoreId(String var1);

        public Builder membershipId(String var1);

        public Builder groupId(String var1);

        public Builder memberId(MemberId var1);

        default public Builder memberId(Consumer<MemberId.Builder> memberId) {
            return this.memberId((MemberId)((MemberId.Builder)MemberId.builder().applyMutation(memberId)).build());
        }
    }
}

