/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningCertificate> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(SigningCertificate.getter(SigningCertificate::userName)).setter(SigningCertificate.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(SigningCertificate.getter(SigningCertificate::certificateId)).setter(SigningCertificate.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateBody").getter(SigningCertificate.getter(SigningCertificate::certificateBody)).setter(SigningCertificate.setter(Builder::certificateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBody").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SigningCertificate.getter(SigningCertificate::statusAsString)).setter(SigningCertificate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPLOAD_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UploadDate").getter(SigningCertificate.getter(SigningCertificate::uploadDate)).setter(SigningCertificate.setter(Builder::uploadDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, CERTIFICATE_ID_FIELD, CERTIFICATE_BODY_FIELD, STATUS_FIELD, UPLOAD_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserName", USER_NAME_FIELD);
            this.put("CertificateId", CERTIFICATE_ID_FIELD);
            this.put("CertificateBody", CERTIFICATE_BODY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("UploadDate", UPLOAD_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String certificateId;
    private final String certificateBody;
    private final String status;
    private final Instant uploadDate;

    private SigningCertificate(BuilderImpl builder) {
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
        this.certificateBody = builder.certificateBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public final String userName() {
        return this.userName;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final String certificateBody() {
        return this.certificateBody;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningCertificate)) {
            return false;
        }
        SigningCertificate other = (SigningCertificate)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.certificateBody(), other.certificateBody()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.uploadDate(), other.uploadDate());
    }

    public final String toString() {
        return ToString.builder((String)"SigningCertificate").add("UserName", (Object)this.userName()).add("CertificateId", (Object)this.certificateId()).add("CertificateBody", (Object)this.certificateBody()).add("Status", (Object)this.statusAsString()).add("UploadDate", (Object)this.uploadDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "CertificateBody": {
                return Optional.ofNullable(clazz.cast(this.certificateBody()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UploadDate": {
                return Optional.ofNullable(clazz.cast(this.uploadDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SigningCertificate, T> g) {
        return obj -> g.apply((SigningCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String certificateId;
        private String certificateBody;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningCertificate model) {
            this.userName(model.userName);
            this.certificateId(model.certificateId);
            this.certificateBody(model.certificateBody);
            this.status(model.status);
            this.uploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public SigningCertificate build() {
            return new SigningCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningCertificate> {
        public Builder userName(String var1);

        public Builder certificateId(String var1);

        public Builder certificateBody(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

