/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._accessKeyMetadataListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessKeysResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListAccessKeysResponse> {
    private static final SdkField<List<AccessKeyMetadata>> ACCESS_KEY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessKeyMetadata").getter(ListAccessKeysResponse.getter(ListAccessKeysResponse::accessKeyMetadata)).setter(ListAccessKeysResponse.setter(Builder::accessKeyMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessKeyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListAccessKeysResponse.getter(ListAccessKeysResponse::isTruncated)).setter(ListAccessKeysResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListAccessKeysResponse.getter(ListAccessKeysResponse::marker)).setter(ListAccessKeysResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_METADATA_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessKeyMetadata", ACCESS_KEY_METADATA_FIELD);
            this.put("IsTruncated", IS_TRUNCATED_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<AccessKeyMetadata> accessKeyMetadata;
    private final Boolean isTruncated;
    private final String marker;

    private ListAccessKeysResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeyMetadata = builder.accessKeyMetadata;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasAccessKeyMetadata() {
        return this.accessKeyMetadata != null && !(this.accessKeyMetadata instanceof SdkAutoConstructList);
    }

    public final List<AccessKeyMetadata> accessKeyMetadata() {
        return this.accessKeyMetadata;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessKeyMetadata() ? this.accessKeyMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessKeysResponse)) {
            return false;
        }
        ListAccessKeysResponse other = (ListAccessKeysResponse)((Object)obj);
        return this.hasAccessKeyMetadata() == other.hasAccessKeyMetadata() && Objects.equals(this.accessKeyMetadata(), other.accessKeyMetadata()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessKeysResponse").add("AccessKeyMetadata", this.hasAccessKeyMetadata() ? this.accessKeyMetadata() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyMetadata": {
                return Optional.ofNullable(clazz.cast(this.accessKeyMetadata()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessKeysResponse, T> g) {
        return obj -> g.apply((ListAccessKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<AccessKeyMetadata> accessKeyMetadata = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessKeysResponse model) {
            super(model);
            this.accessKeyMetadata(model.accessKeyMetadata);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final List<AccessKeyMetadata.Builder> getAccessKeyMetadata() {
            List<AccessKeyMetadata.Builder> result = _accessKeyMetadataListTypeCopier.copyToBuilder(this.accessKeyMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessKeyMetadata(Collection<AccessKeyMetadata.BuilderImpl> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copyFromBuilder(accessKeyMetadata);
        }

        @Override
        public final Builder accessKeyMetadata(Collection<AccessKeyMetadata> accessKeyMetadata) {
            this.accessKeyMetadata = _accessKeyMetadataListTypeCopier.copy(accessKeyMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeyMetadata(AccessKeyMetadata ... accessKeyMetadata) {
            this.accessKeyMetadata(Arrays.asList(accessKeyMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeyMetadata(Consumer<AccessKeyMetadata.Builder> ... accessKeyMetadata) {
            this.accessKeyMetadata(Stream.of(accessKeyMetadata).map(c -> (AccessKeyMetadata)((AccessKeyMetadata.Builder)AccessKeyMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListAccessKeysResponse build() {
            return new ListAccessKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessKeysResponse> {
        public Builder accessKeyMetadata(Collection<AccessKeyMetadata> var1);

        public Builder accessKeyMetadata(AccessKeyMetadata ... var1);

        public Builder accessKeyMetadata(Consumer<AccessKeyMetadata.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

