/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.healthlake.model.FHIRVersion;
import software.amazon.awssdk.services.healthlake.model.HealthLakeRequest;
import software.amazon.awssdk.services.healthlake.model.IdentityProviderConfiguration;
import software.amazon.awssdk.services.healthlake.model.PreloadDataConfig;
import software.amazon.awssdk.services.healthlake.model.SseConfiguration;
import software.amazon.awssdk.services.healthlake.model.Tag;
import software.amazon.awssdk.services.healthlake.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFhirDatastoreRequest
extends HealthLakeRequest
implements ToCopyableBuilder<Builder, CreateFhirDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreName").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::datastoreName)).setter(CreateFhirDatastoreRequest.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()}).build();
    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreTypeVersion").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::datastoreTypeVersionAsString)).setter(CreateFhirDatastoreRequest.setter(Builder::datastoreTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build()}).build();
    private static final SdkField<SseConfiguration> SSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseConfiguration").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::sseConfiguration)).setter(CreateFhirDatastoreRequest.setter(Builder::sseConfiguration)).constructor(SseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseConfiguration").build()}).build();
    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreloadDataConfig").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::preloadDataConfig)).setter(CreateFhirDatastoreRequest.setter(Builder::preloadDataConfig)).constructor(PreloadDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::clientToken)).setter(CreateFhirDatastoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::tags)).setter(CreateFhirDatastoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderConfiguration").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::identityProviderConfiguration)).setter(CreateFhirDatastoreRequest.setter(Builder::identityProviderConfiguration)).constructor(IdentityProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, DATASTORE_TYPE_VERSION_FIELD, SSE_CONFIGURATION_FIELD, PRELOAD_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatastoreName", DATASTORE_NAME_FIELD);
            this.put("DatastoreTypeVersion", DATASTORE_TYPE_VERSION_FIELD);
            this.put("SseConfiguration", SSE_CONFIGURATION_FIELD);
            this.put("PreloadDataConfig", PRELOAD_DATA_CONFIG_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("IdentityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
        }
    });
    private final String datastoreName;
    private final String datastoreTypeVersion;
    private final SseConfiguration sseConfiguration;
    private final PreloadDataConfig preloadDataConfig;
    private final String clientToken;
    private final List<Tag> tags;
    private final IdentityProviderConfiguration identityProviderConfiguration;

    private CreateFhirDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.sseConfiguration = builder.sseConfiguration;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(this.datastoreTypeVersion);
    }

    public final String datastoreTypeVersionAsString() {
        return this.datastoreTypeVersion;
    }

    public final SseConfiguration sseConfiguration() {
        return this.sseConfiguration;
    }

    public final PreloadDataConfig preloadDataConfig() {
        return this.preloadDataConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return this.identityProviderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFhirDatastoreRequest)) {
            return false;
        }
        CreateFhirDatastoreRequest other = (CreateFhirDatastoreRequest)((Object)obj);
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString()) && Objects.equals(this.sseConfiguration(), other.sseConfiguration()) && Objects.equals(this.preloadDataConfig(), other.preloadDataConfig()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.identityProviderConfiguration(), other.identityProviderConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFhirDatastoreRequest").add("DatastoreName", (Object)this.datastoreName()).add("DatastoreTypeVersion", (Object)this.datastoreTypeVersionAsString()).add("SseConfiguration", (Object)this.sseConfiguration()).add("PreloadDataConfig", (Object)this.preloadDataConfig()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("IdentityProviderConfiguration", (Object)this.identityProviderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "DatastoreTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.datastoreTypeVersionAsString()));
            }
            case "SseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sseConfiguration()));
            }
            case "PreloadDataConfig": {
                return Optional.ofNullable(clazz.cast(this.preloadDataConfig()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IdentityProviderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFhirDatastoreRequest, T> g) {
        return obj -> g.apply((CreateFhirDatastoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeRequest.BuilderImpl
    implements Builder {
        private String datastoreName;
        private String datastoreTypeVersion;
        private SseConfiguration sseConfiguration;
        private PreloadDataConfig preloadDataConfig;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private IdentityProviderConfiguration identityProviderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFhirDatastoreRequest model) {
            super(model);
            this.datastoreName(model.datastoreName);
            this.datastoreTypeVersion(model.datastoreTypeVersion);
            this.sseConfiguration(model.sseConfiguration);
            this.preloadDataConfig(model.preloadDataConfig);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.identityProviderConfiguration(model.identityProviderConfiguration);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreTypeVersion() {
            return this.datastoreTypeVersion;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final SseConfiguration.Builder getSseConfiguration() {
            return this.sseConfiguration != null ? this.sseConfiguration.toBuilder() : null;
        }

        public final void setSseConfiguration(SseConfiguration.BuilderImpl sseConfiguration) {
            this.sseConfiguration = sseConfiguration != null ? sseConfiguration.build() : null;
        }

        @Override
        public final Builder sseConfiguration(SseConfiguration sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return this.preloadDataConfig != null ? this.preloadDataConfig.toBuilder() : null;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration != null ? this.identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build() : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFhirDatastoreRequest build() {
            return new CreateFhirDatastoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFhirDatastoreRequest> {
        public Builder datastoreName(String var1);

        public Builder datastoreTypeVersion(String var1);

        public Builder datastoreTypeVersion(FHIRVersion var1);

        public Builder sseConfiguration(SseConfiguration var1);

        default public Builder sseConfiguration(Consumer<SseConfiguration.Builder> sseConfiguration) {
            return this.sseConfiguration((SseConfiguration)((SseConfiguration.Builder)SseConfiguration.builder().applyMutation(sseConfiguration)).build());
        }

        public Builder preloadDataConfig(PreloadDataConfig var1);

        default public Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return this.preloadDataConfig((PreloadDataConfig)((PreloadDataConfig.Builder)PreloadDataConfig.builder().applyMutation(preloadDataConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder identityProviderConfiguration(IdentityProviderConfiguration var1);

        default public Builder identityProviderConfiguration(Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return this.identityProviderConfiguration((IdentityProviderConfiguration)((IdentityProviderConfiguration.Builder)IdentityProviderConfiguration.builder().applyMutation(identityProviderConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

