/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanObjectPrefixesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateS3BucketResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateS3BucketResource> {
    private static final SdkField<List<String>> OBJECT_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectPrefixes").getter(UpdateS3BucketResource.getter(UpdateS3BucketResource::objectPrefixes)).setter(UpdateS3BucketResource.setter(Builder::objectPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PREFIXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("objectPrefixes", OBJECT_PREFIXES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> objectPrefixes;

    private UpdateS3BucketResource(BuilderImpl builder) {
        this.objectPrefixes = builder.objectPrefixes;
    }

    public final boolean hasObjectPrefixes() {
        return this.objectPrefixes != null && !(this.objectPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> objectPrefixes() {
        return this.objectPrefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectPrefixes() ? this.objectPrefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateS3BucketResource)) {
            return false;
        }
        UpdateS3BucketResource other = (UpdateS3BucketResource)obj;
        return this.hasObjectPrefixes() == other.hasObjectPrefixes() && Objects.equals(this.objectPrefixes(), other.objectPrefixes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateS3BucketResource").add("ObjectPrefixes", this.hasObjectPrefixes() ? this.objectPrefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectPrefixes": {
                return Optional.ofNullable(clazz.cast(this.objectPrefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateS3BucketResource, T> g) {
        return obj -> g.apply((UpdateS3BucketResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> objectPrefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateS3BucketResource model) {
            this.objectPrefixes(model.objectPrefixes);
        }

        public final Collection<String> getObjectPrefixes() {
            if (this.objectPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.objectPrefixes;
        }

        public final void setObjectPrefixes(Collection<String> objectPrefixes) {
            this.objectPrefixes = MalwareProtectionPlanObjectPrefixesListCopier.copy(objectPrefixes);
        }

        @Override
        public final Builder objectPrefixes(Collection<String> objectPrefixes) {
            this.objectPrefixes = MalwareProtectionPlanObjectPrefixesListCopier.copy(objectPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectPrefixes(String ... objectPrefixes) {
            this.objectPrefixes(Arrays.asList(objectPrefixes));
            return this;
        }

        public UpdateS3BucketResource build() {
            return new UpdateS3BucketResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateS3BucketResource> {
        public Builder objectPrefixes(Collection<String> var1);

        public Builder objectPrefixes(String ... var1);
    }
}

