/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GroupByType {
    ACCOUNT("ACCOUNT"),
    DATE("DATE"),
    FINDING_TYPE("FINDING_TYPE"),
    RESOURCE("RESOURCE"),
    SEVERITY("SEVERITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupByType> VALUE_MAP;
    private final String value;

    private GroupByType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupByType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GroupByType> knownValues() {
        EnumSet<GroupByType> knownValues = EnumSet.allOf(GroupByType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GroupByType.class, GroupByType::toString);
    }
}

