/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.S3Object;
import software.amazon.awssdk.services.groundstation.model.TLEData;
import software.amazon.awssdk.services.groundstation.model.TLEDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TLEEphemeris
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TLEEphemeris> {
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Object").getter(TLEEphemeris.getter(TLEEphemeris::s3Object)).setter(TLEEphemeris.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final SdkField<List<TLEData>> TLE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tleData").getter(TLEEphemeris.getter(TLEEphemeris::tleData)).setter(TLEEphemeris.setter(Builder::tleData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tleData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TLEData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD, TLE_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3Object", S3_OBJECT_FIELD);
            this.put("tleData", TLE_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3Object s3Object;
    private final List<TLEData> tleData;

    private TLEEphemeris(BuilderImpl builder) {
        this.s3Object = builder.s3Object;
        this.tleData = builder.tleData;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public final boolean hasTleData() {
        return this.tleData != null && !(this.tleData instanceof SdkAutoConstructList);
    }

    public final List<TLEData> tleData() {
        return this.tleData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTleData() ? this.tleData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLEEphemeris)) {
            return false;
        }
        TLEEphemeris other = (TLEEphemeris)obj;
        return Objects.equals(this.s3Object(), other.s3Object()) && this.hasTleData() == other.hasTleData() && Objects.equals(this.tleData(), other.tleData());
    }

    public final String toString() {
        return ToString.builder((String)"TLEEphemeris").add("S3Object", (Object)this.s3Object()).add("TleData", this.hasTleData() ? this.tleData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
            case "tleData": {
                return Optional.ofNullable(clazz.cast(this.tleData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TLEEphemeris, T> g) {
        return obj -> g.apply((TLEEphemeris)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object s3Object;
        private List<TLEData> tleData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TLEEphemeris model) {
            this.s3Object(model.s3Object);
            this.tleData(model.tleData);
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final List<TLEData.Builder> getTleData() {
            List<TLEData.Builder> result = TLEDataListCopier.copyToBuilder(this.tleData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTleData(Collection<TLEData.BuilderImpl> tleData) {
            this.tleData = TLEDataListCopier.copyFromBuilder(tleData);
        }

        @Override
        public final Builder tleData(Collection<TLEData> tleData) {
            this.tleData = TLEDataListCopier.copy(tleData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tleData(TLEData ... tleData) {
            this.tleData(Arrays.asList(tleData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tleData(Consumer<TLEData.Builder> ... tleData) {
            this.tleData(Stream.of(tleData).map(c -> (TLEData)((TLEData.Builder)TLEData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TLEEphemeris build() {
            return new TLEEphemeris(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TLEEphemeris> {
        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }

        public Builder tleData(Collection<TLEData> var1);

        public Builder tleData(TLEData ... var1);

        public Builder tleData(Consumer<TLEData.Builder> ... var1);
    }
}

