/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatusListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEphemeridesRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ListEphemeridesRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::endTime)).setter(ListEphemeridesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::maxResults)).setter(ListEphemeridesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::nextToken)).setter(ListEphemeridesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::satelliteId)).setter(ListEphemeridesRequest.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::startTime)).setter(ListEphemeridesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusList").getter(ListEphemeridesRequest.getter(ListEphemeridesRequest::statusListAsStrings)).setter(ListEphemeridesRequest.setter(Builder::statusListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SATELLITE_ID_FIELD, START_TIME_FIELD, STATUS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("endTime", END_TIME_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("satelliteId", SATELLITE_ID_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("statusList", STATUS_LIST_FIELD);
        }
    });
    private final Instant endTime;
    private final Integer maxResults;
    private final String nextToken;
    private final String satelliteId;
    private final Instant startTime;
    private final List<String> statusList;

    private ListEphemeridesRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.satelliteId = builder.satelliteId;
        this.startTime = builder.startTime;
        this.statusList = builder.statusList;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final List<EphemerisStatus> statusList() {
        return EphemerisStatusListCopier.copyStringToEnum(this.statusList);
    }

    public final boolean hasStatusList() {
        return this.statusList != null && !(this.statusList instanceof SdkAutoConstructList);
    }

    public final List<String> statusListAsStrings() {
        return this.statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusList() ? this.statusListAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEphemeridesRequest)) {
            return false;
        }
        ListEphemeridesRequest other = (ListEphemeridesRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.startTime(), other.startTime()) && this.hasStatusList() == other.hasStatusList() && Objects.equals(this.statusListAsStrings(), other.statusListAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEphemeridesRequest").add("EndTime", (Object)this.endTime()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SatelliteId", (Object)this.satelliteId()).add("StartTime", (Object)this.startTime()).add("StatusList", this.hasStatusList() ? this.statusListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "statusList": {
                return Optional.ofNullable(clazz.cast(this.statusListAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEphemeridesRequest, T> g) {
        return obj -> g.apply((ListEphemeridesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private Integer maxResults;
        private String nextToken;
        private String satelliteId;
        private Instant startTime;
        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEphemeridesRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.satelliteId(model.satelliteId);
            this.startTime(model.startTime);
            this.statusListWithStrings(model.statusList);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getStatusList() {
            if (this.statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusList;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
        }

        @Override
        public final Builder statusListWithStrings(Collection<String> statusList) {
            this.statusList = EphemerisStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusListWithStrings(String ... statusList) {
            this.statusListWithStrings(Arrays.asList(statusList));
            return this;
        }

        @Override
        public final Builder statusList(Collection<EphemerisStatus> statusList) {
            this.statusList = EphemerisStatusListCopier.copyEnumToString(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(EphemerisStatus ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEphemeridesRequest build() {
            return new ListEphemeridesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEphemeridesRequest> {
        public Builder endTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder satelliteId(String var1);

        public Builder startTime(Instant var1);

        public Builder statusListWithStrings(Collection<String> var1);

        public Builder statusListWithStrings(String ... var1);

        public Builder statusList(Collection<EphemerisStatus> var1);

        public Builder statusList(EphemerisStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

