/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.OEMEphemeris;
import software.amazon.awssdk.services.groundstation.model.TLEEphemeris;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EphemerisData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EphemerisData> {
    private static final SdkField<OEMEphemeris> OEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oem").getter(EphemerisData.getter(EphemerisData::oem)).setter(EphemerisData.setter(Builder::oem)).constructor(OEMEphemeris::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oem").build()}).build();
    private static final SdkField<TLEEphemeris> TLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tle").getter(EphemerisData.getter(EphemerisData::tle)).setter(EphemerisData.setter(Builder::tle)).constructor(TLEEphemeris::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OEM_FIELD, TLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("oem", OEM_FIELD);
            this.put("tle", TLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final OEMEphemeris oem;
    private final TLEEphemeris tle;
    private final Type type;

    private EphemerisData(BuilderImpl builder) {
        this.oem = builder.oem;
        this.tle = builder.tle;
        this.type = builder.type;
    }

    public final OEMEphemeris oem() {
        return this.oem;
    }

    public final TLEEphemeris tle() {
        return this.tle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oem());
        hashCode = 31 * hashCode + Objects.hashCode(this.tle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisData)) {
            return false;
        }
        EphemerisData other = (EphemerisData)obj;
        return Objects.equals(this.oem(), other.oem()) && Objects.equals(this.tle(), other.tle());
    }

    public final String toString() {
        return ToString.builder((String)"EphemerisData").add("Oem", (Object)this.oem()).add("Tle", (Object)this.tle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oem": {
                return Optional.ofNullable(clazz.cast(this.oem()));
            }
            case "tle": {
                return Optional.ofNullable(clazz.cast(this.tle()));
            }
        }
        return Optional.empty();
    }

    public static EphemerisData fromOem(OEMEphemeris oem) {
        return (EphemerisData)EphemerisData.builder().oem(oem).build();
    }

    public static EphemerisData fromOem(Consumer<OEMEphemeris.Builder> oem) {
        OEMEphemeris.Builder builder = OEMEphemeris.builder();
        oem.accept(builder);
        return EphemerisData.fromOem((OEMEphemeris)builder.build());
    }

    public static EphemerisData fromTle(TLEEphemeris tle) {
        return (EphemerisData)EphemerisData.builder().tle(tle).build();
    }

    public static EphemerisData fromTle(Consumer<TLEEphemeris.Builder> tle) {
        TLEEphemeris.Builder builder = TLEEphemeris.builder();
        tle.accept(builder);
        return EphemerisData.fromTle((TLEEphemeris)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisData, T> g) {
        return obj -> g.apply((EphemerisData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OEM,
        TLE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OEMEphemeris oem;
        private TLEEphemeris tle;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisData model) {
            this.oem(model.oem);
            this.tle(model.tle);
        }

        public final OEMEphemeris.Builder getOem() {
            return this.oem != null ? this.oem.toBuilder() : null;
        }

        public final void setOem(OEMEphemeris.BuilderImpl oem) {
            OEMEphemeris oldValue = this.oem;
            this.oem = oem != null ? oem.build() : null;
            this.handleUnionValueChange(Type.OEM, oldValue, this.oem);
        }

        @Override
        public final Builder oem(OEMEphemeris oem) {
            OEMEphemeris oldValue = this.oem;
            this.oem = oem;
            this.handleUnionValueChange(Type.OEM, oldValue, this.oem);
            return this;
        }

        public final TLEEphemeris.Builder getTle() {
            return this.tle != null ? this.tle.toBuilder() : null;
        }

        public final void setTle(TLEEphemeris.BuilderImpl tle) {
            TLEEphemeris oldValue = this.tle;
            this.tle = tle != null ? tle.build() : null;
            this.handleUnionValueChange(Type.TLE, oldValue, this.tle);
        }

        @Override
        public final Builder tle(TLEEphemeris tle) {
            TLEEphemeris oldValue = this.tle;
            this.tle = tle;
            this.handleUnionValueChange(Type.TLE, oldValue, this.tle);
            return this;
        }

        public EphemerisData build() {
            return new EphemerisData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EphemerisData> {
        public Builder oem(OEMEphemeris var1);

        default public Builder oem(Consumer<OEMEphemeris.Builder> oem) {
            return this.oem((OEMEphemeris)((OEMEphemeris.Builder)OEMEphemeris.builder().applyMutation(oem)).build());
        }

        public Builder tle(TLEEphemeris var1);

        default public Builder tle(Consumer<TLEEphemeris.Builder> tle) {
            return this.tle((TLEEphemeris)((TLEEphemeris.Builder)TLEEphemeris.builder().applyMutation(tle)).build());
        }
    }
}

