/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.TelemetryConfigurationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThingRuntimeConfigurationRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, UpdateThingRuntimeConfigurationRequest> {
    private static final SdkField<TelemetryConfigurationUpdate> TELEMETRY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TelemetryConfiguration").getter(UpdateThingRuntimeConfigurationRequest.getter(UpdateThingRuntimeConfigurationRequest::telemetryConfiguration)).setter(UpdateThingRuntimeConfigurationRequest.setter(Builder::telemetryConfiguration)).constructor(TelemetryConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfiguration").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThingName").getter(UpdateThingRuntimeConfigurationRequest.getter(UpdateThingRuntimeConfigurationRequest::thingName)).setter(UpdateThingRuntimeConfigurationRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThingName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_CONFIGURATION_FIELD, THING_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TelemetryConfiguration", TELEMETRY_CONFIGURATION_FIELD);
            this.put("ThingName", THING_NAME_FIELD);
        }
    });
    private final TelemetryConfigurationUpdate telemetryConfiguration;
    private final String thingName;

    private UpdateThingRuntimeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.telemetryConfiguration = builder.telemetryConfiguration;
        this.thingName = builder.thingName;
    }

    public final TelemetryConfigurationUpdate telemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    public final String thingName() {
        return this.thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRuntimeConfigurationRequest)) {
            return false;
        }
        UpdateThingRuntimeConfigurationRequest other = (UpdateThingRuntimeConfigurationRequest)((Object)obj);
        return Objects.equals(this.telemetryConfiguration(), other.telemetryConfiguration()) && Objects.equals(this.thingName(), other.thingName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThingRuntimeConfigurationRequest").add("TelemetryConfiguration", (Object)this.telemetryConfiguration()).add("ThingName", (Object)this.thingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.telemetryConfiguration()));
            }
            case "ThingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingRuntimeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateThingRuntimeConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private TelemetryConfigurationUpdate telemetryConfiguration;
        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRuntimeConfigurationRequest model) {
            super(model);
            this.telemetryConfiguration(model.telemetryConfiguration);
            this.thingName(model.thingName);
        }

        public final TelemetryConfigurationUpdate.Builder getTelemetryConfiguration() {
            return this.telemetryConfiguration != null ? this.telemetryConfiguration.toBuilder() : null;
        }

        public final void setTelemetryConfiguration(TelemetryConfigurationUpdate.BuilderImpl telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration != null ? telemetryConfiguration.build() : null;
        }

        @Override
        public final Builder telemetryConfiguration(TelemetryConfigurationUpdate telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingRuntimeConfigurationRequest build() {
            return new UpdateThingRuntimeConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThingRuntimeConfigurationRequest> {
        public Builder telemetryConfiguration(TelemetryConfigurationUpdate var1);

        default public Builder telemetryConfiguration(Consumer<TelemetryConfigurationUpdate.Builder> telemetryConfiguration) {
            return this.telemetryConfiguration((TelemetryConfigurationUpdate)((TelemetryConfigurationUpdate.Builder)TelemetryConfigurationUpdate.builder().applyMutation(telemetryConfiguration)).build());
        }

        public Builder thingName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

