/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CsvHeaderCopier;
import software.amazon.awssdk.services.glue.model.CsvHeaderOption;
import software.amazon.awssdk.services.glue.model.CsvSerdeOption;
import software.amazon.awssdk.services.glue.model.CustomDatatypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCsvClassifierRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateCsvClassifierRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::name)).setter(UpdateCsvClassifierRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::delimiter)).setter(UpdateCsvClassifierRequest.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<String> QUOTE_SYMBOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuoteSymbol").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::quoteSymbol)).setter(UpdateCsvClassifierRequest.setter(Builder::quoteSymbol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteSymbol").build()}).build();
    private static final SdkField<String> CONTAINS_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainsHeader").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::containsHeaderAsString)).setter(UpdateCsvClassifierRequest.setter(Builder::containsHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()}).build();
    private static final SdkField<List<String>> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Header").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::header)).setter(UpdateCsvClassifierRequest.setter(Builder::header)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLE_VALUE_TRIMMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableValueTrimming").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::disableValueTrimming)).setter(UpdateCsvClassifierRequest.setter(Builder::disableValueTrimming)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableValueTrimming").build()}).build();
    private static final SdkField<Boolean> ALLOW_SINGLE_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSingleColumn").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::allowSingleColumn)).setter(UpdateCsvClassifierRequest.setter(Builder::allowSingleColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSingleColumn").build()}).build();
    private static final SdkField<Boolean> CUSTOM_DATATYPE_CONFIGURED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CustomDatatypeConfigured").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::customDatatypeConfigured)).setter(UpdateCsvClassifierRequest.setter(Builder::customDatatypeConfigured)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDatatypeConfigured").build()}).build();
    private static final SdkField<List<String>> CUSTOM_DATATYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomDatatypes").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::customDatatypes)).setter(UpdateCsvClassifierRequest.setter(Builder::customDatatypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDatatypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Serde").getter(UpdateCsvClassifierRequest.getter(UpdateCsvClassifierRequest::serdeAsString)).setter(UpdateCsvClassifierRequest.setter(Builder::serde)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serde").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DELIMITER_FIELD, QUOTE_SYMBOL_FIELD, CONTAINS_HEADER_FIELD, HEADER_FIELD, DISABLE_VALUE_TRIMMING_FIELD, ALLOW_SINGLE_COLUMN_FIELD, CUSTOM_DATATYPE_CONFIGURED_FIELD, CUSTOM_DATATYPES_FIELD, SERDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Delimiter", DELIMITER_FIELD);
            this.put("QuoteSymbol", QUOTE_SYMBOL_FIELD);
            this.put("ContainsHeader", CONTAINS_HEADER_FIELD);
            this.put("Header", HEADER_FIELD);
            this.put("DisableValueTrimming", DISABLE_VALUE_TRIMMING_FIELD);
            this.put("AllowSingleColumn", ALLOW_SINGLE_COLUMN_FIELD);
            this.put("CustomDatatypeConfigured", CUSTOM_DATATYPE_CONFIGURED_FIELD);
            this.put("CustomDatatypes", CUSTOM_DATATYPES_FIELD);
            this.put("Serde", SERDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String delimiter;
    private final String quoteSymbol;
    private final String containsHeader;
    private final List<String> header;
    private final Boolean disableValueTrimming;
    private final Boolean allowSingleColumn;
    private final Boolean customDatatypeConfigured;
    private final List<String> customDatatypes;
    private final String serde;

    private UpdateCsvClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.delimiter = builder.delimiter;
        this.quoteSymbol = builder.quoteSymbol;
        this.containsHeader = builder.containsHeader;
        this.header = builder.header;
        this.disableValueTrimming = builder.disableValueTrimming;
        this.allowSingleColumn = builder.allowSingleColumn;
        this.customDatatypeConfigured = builder.customDatatypeConfigured;
        this.customDatatypes = builder.customDatatypes;
        this.serde = builder.serde;
    }

    public final String name() {
        return this.name;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final String quoteSymbol() {
        return this.quoteSymbol;
    }

    public final CsvHeaderOption containsHeader() {
        return CsvHeaderOption.fromValue(this.containsHeader);
    }

    public final String containsHeaderAsString() {
        return this.containsHeader;
    }

    public final boolean hasHeader() {
        return this.header != null && !(this.header instanceof SdkAutoConstructList);
    }

    public final List<String> header() {
        return this.header;
    }

    public final Boolean disableValueTrimming() {
        return this.disableValueTrimming;
    }

    public final Boolean allowSingleColumn() {
        return this.allowSingleColumn;
    }

    public final Boolean customDatatypeConfigured() {
        return this.customDatatypeConfigured;
    }

    public final boolean hasCustomDatatypes() {
        return this.customDatatypes != null && !(this.customDatatypes instanceof SdkAutoConstructList);
    }

    public final List<String> customDatatypes() {
        return this.customDatatypes;
    }

    public final CsvSerdeOption serde() {
        return CsvSerdeOption.fromValue(this.serde);
    }

    public final String serdeAsString() {
        return this.serde;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteSymbol());
        hashCode = 31 * hashCode + Objects.hashCode(this.containsHeaderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeader() ? this.header() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disableValueTrimming());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSingleColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDatatypeConfigured());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDatatypes() ? this.customDatatypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serdeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCsvClassifierRequest)) {
            return false;
        }
        UpdateCsvClassifierRequest other = (UpdateCsvClassifierRequest)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.quoteSymbol(), other.quoteSymbol()) && Objects.equals(this.containsHeaderAsString(), other.containsHeaderAsString()) && this.hasHeader() == other.hasHeader() && Objects.equals(this.header(), other.header()) && Objects.equals(this.disableValueTrimming(), other.disableValueTrimming()) && Objects.equals(this.allowSingleColumn(), other.allowSingleColumn()) && Objects.equals(this.customDatatypeConfigured(), other.customDatatypeConfigured()) && this.hasCustomDatatypes() == other.hasCustomDatatypes() && Objects.equals(this.customDatatypes(), other.customDatatypes()) && Objects.equals(this.serdeAsString(), other.serdeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCsvClassifierRequest").add("Name", (Object)this.name()).add("Delimiter", (Object)this.delimiter()).add("QuoteSymbol", (Object)this.quoteSymbol()).add("ContainsHeader", (Object)this.containsHeaderAsString()).add("Header", this.hasHeader() ? this.header() : null).add("DisableValueTrimming", (Object)this.disableValueTrimming()).add("AllowSingleColumn", (Object)this.allowSingleColumn()).add("CustomDatatypeConfigured", (Object)this.customDatatypeConfigured()).add("CustomDatatypes", this.hasCustomDatatypes() ? this.customDatatypes() : null).add("Serde", (Object)this.serdeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "QuoteSymbol": {
                return Optional.ofNullable(clazz.cast(this.quoteSymbol()));
            }
            case "ContainsHeader": {
                return Optional.ofNullable(clazz.cast(this.containsHeaderAsString()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "DisableValueTrimming": {
                return Optional.ofNullable(clazz.cast(this.disableValueTrimming()));
            }
            case "AllowSingleColumn": {
                return Optional.ofNullable(clazz.cast(this.allowSingleColumn()));
            }
            case "CustomDatatypeConfigured": {
                return Optional.ofNullable(clazz.cast(this.customDatatypeConfigured()));
            }
            case "CustomDatatypes": {
                return Optional.ofNullable(clazz.cast(this.customDatatypes()));
            }
            case "Serde": {
                return Optional.ofNullable(clazz.cast(this.serdeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCsvClassifierRequest, T> g) {
        return obj -> g.apply((UpdateCsvClassifierRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String delimiter;
        private String quoteSymbol;
        private String containsHeader;
        private List<String> header = DefaultSdkAutoConstructList.getInstance();
        private Boolean disableValueTrimming;
        private Boolean allowSingleColumn;
        private Boolean customDatatypeConfigured;
        private List<String> customDatatypes = DefaultSdkAutoConstructList.getInstance();
        private String serde;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCsvClassifierRequest model) {
            this.name(model.name);
            this.delimiter(model.delimiter);
            this.quoteSymbol(model.quoteSymbol);
            this.containsHeader(model.containsHeader);
            this.header(model.header);
            this.disableValueTrimming(model.disableValueTrimming);
            this.allowSingleColumn(model.allowSingleColumn);
            this.customDatatypeConfigured(model.customDatatypeConfigured);
            this.customDatatypes(model.customDatatypes);
            this.serde(model.serde);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final String getQuoteSymbol() {
            return this.quoteSymbol;
        }

        public final void setQuoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
        }

        @Override
        public final Builder quoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        public final String getContainsHeader() {
            return this.containsHeader;
        }

        public final void setContainsHeader(String containsHeader) {
            this.containsHeader = containsHeader;
        }

        @Override
        public final Builder containsHeader(String containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        @Override
        public final Builder containsHeader(CsvHeaderOption containsHeader) {
            this.containsHeader(containsHeader == null ? null : containsHeader.toString());
            return this;
        }

        public final Collection<String> getHeader() {
            if (this.header instanceof SdkAutoConstructList) {
                return null;
            }
            return this.header;
        }

        public final void setHeader(Collection<String> header) {
            this.header = CsvHeaderCopier.copy(header);
        }

        @Override
        public final Builder header(Collection<String> header) {
            this.header = CsvHeaderCopier.copy(header);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder header(String ... header) {
            this.header(Arrays.asList(header));
            return this;
        }

        public final Boolean getDisableValueTrimming() {
            return this.disableValueTrimming;
        }

        public final void setDisableValueTrimming(Boolean disableValueTrimming) {
            this.disableValueTrimming = disableValueTrimming;
        }

        @Override
        public final Builder disableValueTrimming(Boolean disableValueTrimming) {
            this.disableValueTrimming = disableValueTrimming;
            return this;
        }

        public final Boolean getAllowSingleColumn() {
            return this.allowSingleColumn;
        }

        public final void setAllowSingleColumn(Boolean allowSingleColumn) {
            this.allowSingleColumn = allowSingleColumn;
        }

        @Override
        public final Builder allowSingleColumn(Boolean allowSingleColumn) {
            this.allowSingleColumn = allowSingleColumn;
            return this;
        }

        public final Boolean getCustomDatatypeConfigured() {
            return this.customDatatypeConfigured;
        }

        public final void setCustomDatatypeConfigured(Boolean customDatatypeConfigured) {
            this.customDatatypeConfigured = customDatatypeConfigured;
        }

        @Override
        public final Builder customDatatypeConfigured(Boolean customDatatypeConfigured) {
            this.customDatatypeConfigured = customDatatypeConfigured;
            return this;
        }

        public final Collection<String> getCustomDatatypes() {
            if (this.customDatatypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDatatypes;
        }

        public final void setCustomDatatypes(Collection<String> customDatatypes) {
            this.customDatatypes = CustomDatatypesCopier.copy(customDatatypes);
        }

        @Override
        public final Builder customDatatypes(Collection<String> customDatatypes) {
            this.customDatatypes = CustomDatatypesCopier.copy(customDatatypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDatatypes(String ... customDatatypes) {
            this.customDatatypes(Arrays.asList(customDatatypes));
            return this;
        }

        public final String getSerde() {
            return this.serde;
        }

        public final void setSerde(String serde) {
            this.serde = serde;
        }

        @Override
        public final Builder serde(String serde) {
            this.serde = serde;
            return this;
        }

        @Override
        public final Builder serde(CsvSerdeOption serde) {
            this.serde(serde == null ? null : serde.toString());
            return this;
        }

        public UpdateCsvClassifierRequest build() {
            return new UpdateCsvClassifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateCsvClassifierRequest> {
        public Builder name(String var1);

        public Builder delimiter(String var1);

        public Builder quoteSymbol(String var1);

        public Builder containsHeader(String var1);

        public Builder containsHeader(CsvHeaderOption var1);

        public Builder header(Collection<String> var1);

        public Builder header(String ... var1);

        public Builder disableValueTrimming(Boolean var1);

        public Builder allowSingleColumn(Boolean var1);

        public Builder customDatatypeConfigured(Boolean var1);

        public Builder customDatatypes(Collection<String> var1);

        public Builder customDatatypes(String ... var1);

        public Builder serde(String var1);

        public Builder serde(CsvSerdeOption var1);
    }
}

