/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportLabelsTaskRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartExportLabelsTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(StartExportLabelsTaskRunRequest.getter(StartExportLabelsTaskRunRequest::transformId)).setter(StartExportLabelsTaskRunRequest.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3Path").getter(StartExportLabelsTaskRunRequest.getter(StartExportLabelsTaskRunRequest::outputS3Path)).setter(StartExportLabelsTaskRunRequest.setter(Builder::outputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, OUTPUT_S3_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransformId", TRANSFORM_ID_FIELD);
            this.put("OutputS3Path", OUTPUT_S3_PATH_FIELD);
        }
    });
    private final String transformId;
    private final String outputS3Path;

    private StartExportLabelsTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.outputS3Path = builder.outputS3Path;
    }

    public final String transformId() {
        return this.transformId;
    }

    public final String outputS3Path() {
        return this.outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportLabelsTaskRunRequest)) {
            return false;
        }
        StartExportLabelsTaskRunRequest other = (StartExportLabelsTaskRunRequest)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.outputS3Path(), other.outputS3Path());
    }

    public final String toString() {
        return ToString.builder((String)"StartExportLabelsTaskRunRequest").add("TransformId", (Object)this.transformId()).add("OutputS3Path", (Object)this.outputS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "OutputS3Path": {
                return Optional.ofNullable(clazz.cast(this.outputS3Path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExportLabelsTaskRunRequest, T> g) {
        return obj -> g.apply((StartExportLabelsTaskRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String transformId;
        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportLabelsTaskRunRequest model) {
            super(model);
            this.transformId(model.transformId);
            this.outputS3Path(model.outputS3Path);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getOutputS3Path() {
            return this.outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportLabelsTaskRunRequest build() {
            return new StartExportLabelsTaskRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportLabelsTaskRunRequest> {
        public Builder transformId(String var1);

        public Builder outputS3Path(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

