/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3SourceAdditionalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3SourceAdditionalOptions> {
    private static final SdkField<Long> BOUNDED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BoundedSize").getter(S3SourceAdditionalOptions.getter(S3SourceAdditionalOptions::boundedSize)).setter(S3SourceAdditionalOptions.setter(Builder::boundedSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedSize").build()}).build();
    private static final SdkField<Long> BOUNDED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BoundedFiles").getter(S3SourceAdditionalOptions.getter(S3SourceAdditionalOptions::boundedFiles)).setter(S3SourceAdditionalOptions.setter(Builder::boundedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedFiles").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDED_SIZE_FIELD, BOUNDED_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BoundedSize", BOUNDED_SIZE_FIELD);
            this.put("BoundedFiles", BOUNDED_FILES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long boundedSize;
    private final Long boundedFiles;

    private S3SourceAdditionalOptions(BuilderImpl builder) {
        this.boundedSize = builder.boundedSize;
        this.boundedFiles = builder.boundedFiles;
    }

    public final Long boundedSize() {
        return this.boundedSize;
    }

    public final Long boundedFiles() {
        return this.boundedFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundedSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundedFiles());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceAdditionalOptions)) {
            return false;
        }
        S3SourceAdditionalOptions other = (S3SourceAdditionalOptions)obj;
        return Objects.equals(this.boundedSize(), other.boundedSize()) && Objects.equals(this.boundedFiles(), other.boundedFiles());
    }

    public final String toString() {
        return ToString.builder((String)"S3SourceAdditionalOptions").add("BoundedSize", (Object)this.boundedSize()).add("BoundedFiles", (Object)this.boundedFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundedSize": {
                return Optional.ofNullable(clazz.cast(this.boundedSize()));
            }
            case "BoundedFiles": {
                return Optional.ofNullable(clazz.cast(this.boundedFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3SourceAdditionalOptions, T> g) {
        return obj -> g.apply((S3SourceAdditionalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long boundedSize;
        private Long boundedFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceAdditionalOptions model) {
            this.boundedSize(model.boundedSize);
            this.boundedFiles(model.boundedFiles);
        }

        public final Long getBoundedSize() {
            return this.boundedSize;
        }

        public final void setBoundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
        }

        @Override
        public final Builder boundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
            return this;
        }

        public final Long getBoundedFiles() {
            return this.boundedFiles;
        }

        public final void setBoundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
        }

        @Override
        public final Builder boundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
            return this;
        }

        public S3SourceAdditionalOptions build() {
            return new S3SourceAdditionalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3SourceAdditionalOptions> {
        public Builder boundedSize(Long var1);

        public Builder boundedFiles(Long var1);
    }
}

