/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.RegistryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRegistryResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetRegistryResponse> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(GetRegistryResponse.getter(GetRegistryResponse::registryName)).setter(GetRegistryResponse.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()}).build();
    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryArn").getter(GetRegistryResponse.getter(GetRegistryResponse::registryArn)).setter(GetRegistryResponse.setter(Builder::registryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetRegistryResponse.getter(GetRegistryResponse::description)).setter(GetRegistryResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetRegistryResponse.getter(GetRegistryResponse::statusAsString)).setter(GetRegistryResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(GetRegistryResponse.getter(GetRegistryResponse::createdTime)).setter(GetRegistryResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedTime").getter(GetRegistryResponse.getter(GetRegistryResponse::updatedTime)).setter(GetRegistryResponse.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD, REGISTRY_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RegistryName", REGISTRY_NAME_FIELD);
            this.put("RegistryArn", REGISTRY_ARN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("UpdatedTime", UPDATED_TIME_FIELD);
        }
    });
    private final String registryName;
    private final String registryArn;
    private final String description;
    private final String status;
    private final String createdTime;
    private final String updatedTime;

    private GetRegistryResponse(BuilderImpl builder) {
        super(builder);
        this.registryName = builder.registryName;
        this.registryArn = builder.registryArn;
        this.description = builder.description;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    public final String registryName() {
        return this.registryName;
    }

    public final String registryArn() {
        return this.registryArn;
    }

    public final String description() {
        return this.description;
    }

    public final RegistryStatus status() {
        return RegistryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String updatedTime() {
        return this.updatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistryResponse)) {
            return false;
        }
        GetRegistryResponse other = (GetRegistryResponse)((Object)obj);
        return Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.registryArn(), other.registryArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.updatedTime(), other.updatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetRegistryResponse").add("RegistryName", (Object)this.registryName()).add("RegistryArn", (Object)this.registryArn()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("UpdatedTime", (Object)this.updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "RegistryArn": {
                return Optional.ofNullable(clazz.cast(this.registryArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRegistryResponse, T> g) {
        return obj -> g.apply((GetRegistryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String registryName;
        private String registryArn;
        private String description;
        private String status;
        private String createdTime;
        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistryResponse model) {
            super(model);
            this.registryName(model.registryName);
            this.registryArn(model.registryArn);
            this.description(model.description);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getRegistryArn() {
            return this.registryArn;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @Override
        public GetRegistryResponse build() {
            return new GetRegistryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRegistryResponse> {
        public Builder registryName(String var1);

        public Builder registryArn(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(RegistryStatus var1);

        public Builder createdTime(String var1);

        public Builder updatedTime(String var1);
    }
}

