/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CloudWatchEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchEncryption> {
    private static final SdkField<String> CLOUD_WATCH_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchEncryptionMode").getter(CloudWatchEncryption.getter(CloudWatchEncryption::cloudWatchEncryptionModeAsString)).setter(CloudWatchEncryption.setter(Builder::cloudWatchEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEncryptionMode").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CloudWatchEncryption.getter(CloudWatchEncryption::kmsKeyArn)).setter(CloudWatchEncryption.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ENCRYPTION_MODE_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudWatchEncryptionMode", CLOUD_WATCH_ENCRYPTION_MODE_FIELD);
            this.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cloudWatchEncryptionMode;
    private final String kmsKeyArn;

    private CloudWatchEncryption(BuilderImpl builder) {
        this.cloudWatchEncryptionMode = builder.cloudWatchEncryptionMode;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final CloudWatchEncryptionMode cloudWatchEncryptionMode() {
        return CloudWatchEncryptionMode.fromValue(this.cloudWatchEncryptionMode);
    }

    public final String cloudWatchEncryptionModeAsString() {
        return this.cloudWatchEncryptionMode;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchEncryption)) {
            return false;
        }
        CloudWatchEncryption other = (CloudWatchEncryption)obj;
        return Objects.equals(this.cloudWatchEncryptionModeAsString(), other.cloudWatchEncryptionModeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchEncryption").add("CloudWatchEncryptionMode", (Object)this.cloudWatchEncryptionModeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEncryptionModeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchEncryption, T> g) {
        return obj -> g.apply((CloudWatchEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchEncryptionMode;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchEncryption model) {
            this.cloudWatchEncryptionMode(model.cloudWatchEncryptionMode);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getCloudWatchEncryptionMode() {
            return this.cloudWatchEncryptionMode;
        }

        public final void setCloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(String cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode = cloudWatchEncryptionMode;
            return this;
        }

        @Override
        public final Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode cloudWatchEncryptionMode) {
            this.cloudWatchEncryptionMode(cloudWatchEncryptionMode == null ? null : cloudWatchEncryptionMode.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public CloudWatchEncryption build() {
            return new CloudWatchEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchEncryption> {
        public Builder cloudWatchEncryptionMode(String var1);

        public Builder cloudWatchEncryptionMode(CloudWatchEncryptionMode var1);

        public Builder kmsKeyArn(String var1);
    }
}

