/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.BalancingStrategy;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameServerProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinition;
import software.amazon.awssdk.services.gamelift.model.InstanceDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameServerGroupRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerGroupName").getter(UpdateGameServerGroupRequest.getter(UpdateGameServerGroupRequest::gameServerGroupName)).setter(UpdateGameServerGroupRequest.setter(Builder::gameServerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateGameServerGroupRequest.getter(UpdateGameServerGroupRequest::roleArn)).setter(UpdateGameServerGroupRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<InstanceDefinition>> INSTANCE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceDefinitions").getter(UpdateGameServerGroupRequest.getter(UpdateGameServerGroupRequest::instanceDefinitions)).setter(UpdateGameServerGroupRequest.setter(Builder::instanceDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GAME_SERVER_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerProtectionPolicy").getter(UpdateGameServerGroupRequest.getter(UpdateGameServerGroupRequest::gameServerProtectionPolicyAsString)).setter(UpdateGameServerGroupRequest.setter(Builder::gameServerProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerProtectionPolicy").build()}).build();
    private static final SdkField<String> BALANCING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BalancingStrategy").getter(UpdateGameServerGroupRequest.getter(UpdateGameServerGroupRequest::balancingStrategyAsString)).setter(UpdateGameServerGroupRequest.setter(Builder::balancingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BalancingStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD, ROLE_ARN_FIELD, INSTANCE_DEFINITIONS_FIELD, GAME_SERVER_PROTECTION_POLICY_FIELD, BALANCING_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GameServerGroupName", GAME_SERVER_GROUP_NAME_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("InstanceDefinitions", INSTANCE_DEFINITIONS_FIELD);
            this.put("GameServerProtectionPolicy", GAME_SERVER_PROTECTION_POLICY_FIELD);
            this.put("BalancingStrategy", BALANCING_STRATEGY_FIELD);
        }
    });
    private final String gameServerGroupName;
    private final String roleArn;
    private final List<InstanceDefinition> instanceDefinitions;
    private final String gameServerProtectionPolicy;
    private final String balancingStrategy;

    private UpdateGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.roleArn = builder.roleArn;
        this.instanceDefinitions = builder.instanceDefinitions;
        this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
        this.balancingStrategy = builder.balancingStrategy;
    }

    public final String gameServerGroupName() {
        return this.gameServerGroupName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasInstanceDefinitions() {
        return this.instanceDefinitions != null && !(this.instanceDefinitions instanceof SdkAutoConstructList);
    }

    public final List<InstanceDefinition> instanceDefinitions() {
        return this.instanceDefinitions;
    }

    public final GameServerProtectionPolicy gameServerProtectionPolicy() {
        return GameServerProtectionPolicy.fromValue(this.gameServerProtectionPolicy);
    }

    public final String gameServerProtectionPolicyAsString() {
        return this.gameServerProtectionPolicy;
    }

    public final BalancingStrategy balancingStrategy() {
        return BalancingStrategy.fromValue(this.balancingStrategy);
    }

    public final String balancingStrategyAsString() {
        return this.balancingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceDefinitions() ? this.instanceDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.balancingStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameServerGroupRequest)) {
            return false;
        }
        UpdateGameServerGroupRequest other = (UpdateGameServerGroupRequest)((Object)obj);
        return Objects.equals(this.gameServerGroupName(), other.gameServerGroupName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasInstanceDefinitions() == other.hasInstanceDefinitions() && Objects.equals(this.instanceDefinitions(), other.instanceDefinitions()) && Objects.equals(this.gameServerProtectionPolicyAsString(), other.gameServerProtectionPolicyAsString()) && Objects.equals(this.balancingStrategyAsString(), other.balancingStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGameServerGroupRequest").add("GameServerGroupName", (Object)this.gameServerGroupName()).add("RoleArn", (Object)this.roleArn()).add("InstanceDefinitions", this.hasInstanceDefinitions() ? this.instanceDefinitions() : null).add("GameServerProtectionPolicy", (Object)this.gameServerProtectionPolicyAsString()).add("BalancingStrategy", (Object)this.balancingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServerGroupName": {
                return Optional.ofNullable(clazz.cast(this.gameServerGroupName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InstanceDefinitions": {
                return Optional.ofNullable(clazz.cast(this.instanceDefinitions()));
            }
            case "GameServerProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.gameServerProtectionPolicyAsString()));
            }
            case "BalancingStrategy": {
                return Optional.ofNullable(clazz.cast(this.balancingStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameServerGroupRequest, T> g) {
        return obj -> g.apply((UpdateGameServerGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameServerGroupName;
        private String roleArn;
        private List<InstanceDefinition> instanceDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String gameServerProtectionPolicy;
        private String balancingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameServerGroupRequest model) {
            super(model);
            this.gameServerGroupName(model.gameServerGroupName);
            this.roleArn(model.roleArn);
            this.instanceDefinitions(model.instanceDefinitions);
            this.gameServerProtectionPolicy(model.gameServerProtectionPolicy);
            this.balancingStrategy(model.balancingStrategy);
        }

        public final String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InstanceDefinition.Builder> getInstanceDefinitions() {
            List<InstanceDefinition.Builder> result = InstanceDefinitionsCopier.copyToBuilder(this.instanceDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceDefinitions(Collection<InstanceDefinition.BuilderImpl> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copyFromBuilder(instanceDefinitions);
        }

        @Override
        public final Builder instanceDefinitions(Collection<InstanceDefinition> instanceDefinitions) {
            this.instanceDefinitions = InstanceDefinitionsCopier.copy(instanceDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(InstanceDefinition ... instanceDefinitions) {
            this.instanceDefinitions(Arrays.asList(instanceDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... instanceDefinitions) {
            this.instanceDefinitions(Stream.of(instanceDefinitions).map(c -> (InstanceDefinition)((InstanceDefinition.Builder)InstanceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGameServerProtectionPolicy() {
            return this.gameServerProtectionPolicy;
        }

        public final void setGameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
        }

        @Override
        public final Builder gameServerProtectionPolicy(String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        @Override
        public final Builder gameServerProtectionPolicy(GameServerProtectionPolicy gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy(gameServerProtectionPolicy == null ? null : gameServerProtectionPolicy.toString());
            return this;
        }

        public final String getBalancingStrategy() {
            return this.balancingStrategy;
        }

        public final void setBalancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
        }

        @Override
        public final Builder balancingStrategy(String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        @Override
        public final Builder balancingStrategy(BalancingStrategy balancingStrategy) {
            this.balancingStrategy(balancingStrategy == null ? null : balancingStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameServerGroupRequest build() {
            return new UpdateGameServerGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGameServerGroupRequest> {
        public Builder gameServerGroupName(String var1);

        public Builder roleArn(String var1);

        public Builder instanceDefinitions(Collection<InstanceDefinition> var1);

        public Builder instanceDefinitions(InstanceDefinition ... var1);

        public Builder instanceDefinitions(Consumer<InstanceDefinition.Builder> ... var1);

        public Builder gameServerProtectionPolicy(String var1);

        public Builder gameServerProtectionPolicy(GameServerProtectionPolicy var1);

        public Builder balancingStrategy(String var1);

        public Builder balancingStrategy(BalancingStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

