/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ElementsListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetListElementsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetListElementsResponse> {
    private static final SdkField<List<String>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("elements").getter(GetListElementsResponse.getter(GetListElementsResponse::elements)).setter(GetListElementsResponse.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetListElementsResponse.getter(GetListElementsResponse::nextToken)).setter(GetListElementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("elements", ELEMENTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> elements;
    private final String nextToken;

    private GetListElementsResponse(BuilderImpl builder) {
        super(builder);
        this.elements = builder.elements;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<String> elements() {
        return this.elements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetListElementsResponse)) {
            return false;
        }
        GetListElementsResponse other = (GetListElementsResponse)((Object)obj);
        return this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetListElementsResponse").add("Elements", (Object)(this.elements() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetListElementsResponse, T> g) {
        return obj -> g.apply((GetListElementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<String> elements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetListElementsResponse model) {
            super(model);
            this.elements(model.elements);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getElements() {
            if (this.elements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.elements;
        }

        public final void setElements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
        }

        @Override
        public final Builder elements(Collection<String> elements) {
            this.elements = ElementsListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(String ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetListElementsResponse build() {
            return new GetListElementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetListElementsResponse> {
        public Builder elements(Collection<String> var1);

        public Builder elements(String ... var1);

        public Builder nextToken(String var1);
    }
}

