/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfAnalysesCopier;
import software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWhatIfAnalysesResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListWhatIfAnalysesResponse> {
    private static final SdkField<List<WhatIfAnalysisSummary>> WHAT_IF_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WhatIfAnalyses").getter(ListWhatIfAnalysesResponse.getter(ListWhatIfAnalysesResponse::whatIfAnalyses)).setter(ListWhatIfAnalysesResponse.setter(Builder::whatIfAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalyses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatIfAnalysisSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWhatIfAnalysesResponse.getter(ListWhatIfAnalysesResponse::nextToken)).setter(ListWhatIfAnalysesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_ANALYSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WhatIfAnalyses", WHAT_IF_ANALYSES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<WhatIfAnalysisSummary> whatIfAnalyses;
    private final String nextToken;

    private ListWhatIfAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfAnalyses = builder.whatIfAnalyses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWhatIfAnalyses() {
        return this.whatIfAnalyses != null && !(this.whatIfAnalyses instanceof SdkAutoConstructList);
    }

    public final List<WhatIfAnalysisSummary> whatIfAnalyses() {
        return this.whatIfAnalyses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWhatIfAnalyses() ? this.whatIfAnalyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatIfAnalysesResponse)) {
            return false;
        }
        ListWhatIfAnalysesResponse other = (ListWhatIfAnalysesResponse)((Object)obj);
        return this.hasWhatIfAnalyses() == other.hasWhatIfAnalyses() && Objects.equals(this.whatIfAnalyses(), other.whatIfAnalyses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWhatIfAnalysesResponse").add("WhatIfAnalyses", this.hasWhatIfAnalyses() ? this.whatIfAnalyses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfAnalyses": {
                return Optional.ofNullable(clazz.cast(this.whatIfAnalyses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWhatIfAnalysesResponse, T> g) {
        return obj -> g.apply((ListWhatIfAnalysesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<WhatIfAnalysisSummary> whatIfAnalyses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatIfAnalysesResponse model) {
            super(model);
            this.whatIfAnalyses(model.whatIfAnalyses);
            this.nextToken(model.nextToken);
        }

        public final List<WhatIfAnalysisSummary.Builder> getWhatIfAnalyses() {
            List<WhatIfAnalysisSummary.Builder> result = WhatIfAnalysesCopier.copyToBuilder(this.whatIfAnalyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWhatIfAnalyses(Collection<WhatIfAnalysisSummary.BuilderImpl> whatIfAnalyses) {
            this.whatIfAnalyses = WhatIfAnalysesCopier.copyFromBuilder(whatIfAnalyses);
        }

        @Override
        public final Builder whatIfAnalyses(Collection<WhatIfAnalysisSummary> whatIfAnalyses) {
            this.whatIfAnalyses = WhatIfAnalysesCopier.copy(whatIfAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfAnalyses(WhatIfAnalysisSummary ... whatIfAnalyses) {
            this.whatIfAnalyses(Arrays.asList(whatIfAnalyses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfAnalyses(Consumer<WhatIfAnalysisSummary.Builder> ... whatIfAnalyses) {
            this.whatIfAnalyses(Stream.of(whatIfAnalyses).map(c -> (WhatIfAnalysisSummary)((WhatIfAnalysisSummary.Builder)WhatIfAnalysisSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatIfAnalysesResponse build() {
            return new ListWhatIfAnalysesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWhatIfAnalysesResponse> {
        public Builder whatIfAnalyses(Collection<WhatIfAnalysisSummary> var1);

        public Builder whatIfAnalyses(WhatIfAnalysisSummary ... var1);

        public Builder whatIfAnalyses(Consumer<WhatIfAnalysisSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

