/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.OrganizationalUnitIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationalUnitScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationalUnitScope> {
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnits").getter(OrganizationalUnitScope.getter(OrganizationalUnitScope::organizationalUnits)).setter(OrganizationalUnitScope.setter(Builder::organizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllOrganizationalUnitsEnabled").getter(OrganizationalUnitScope.getter(OrganizationalUnitScope::allOrganizationalUnitsEnabled)).setter(OrganizationalUnitScope.setter(Builder::allOrganizationalUnitsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllOrganizationalUnitsEnabled").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeSpecifiedOrganizationalUnits").getter(OrganizationalUnitScope.getter(OrganizationalUnitScope::excludeSpecifiedOrganizationalUnits)).setter(OrganizationalUnitScope.setter(Builder::excludeSpecifiedOrganizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSpecifiedOrganizationalUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNITS_FIELD, ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD, EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationalUnits", ORGANIZATIONAL_UNITS_FIELD);
            this.put("AllOrganizationalUnitsEnabled", ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD);
            this.put("ExcludeSpecifiedOrganizationalUnits", EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> organizationalUnits;
    private final Boolean allOrganizationalUnitsEnabled;
    private final Boolean excludeSpecifiedOrganizationalUnits;

    private OrganizationalUnitScope(BuilderImpl builder) {
        this.organizationalUnits = builder.organizationalUnits;
        this.allOrganizationalUnitsEnabled = builder.allOrganizationalUnitsEnabled;
        this.excludeSpecifiedOrganizationalUnits = builder.excludeSpecifiedOrganizationalUnits;
    }

    public final boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !(this.organizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnits() {
        return this.organizationalUnits;
    }

    public final Boolean allOrganizationalUnitsEnabled() {
        return this.allOrganizationalUnitsEnabled;
    }

    public final Boolean excludeSpecifiedOrganizationalUnits() {
        return this.excludeSpecifiedOrganizationalUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnits() ? this.organizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allOrganizationalUnitsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeSpecifiedOrganizationalUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationalUnitScope)) {
            return false;
        }
        OrganizationalUnitScope other = (OrganizationalUnitScope)obj;
        return this.hasOrganizationalUnits() == other.hasOrganizationalUnits() && Objects.equals(this.organizationalUnits(), other.organizationalUnits()) && Objects.equals(this.allOrganizationalUnitsEnabled(), other.allOrganizationalUnitsEnabled()) && Objects.equals(this.excludeSpecifiedOrganizationalUnits(), other.excludeSpecifiedOrganizationalUnits());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationalUnitScope").add("OrganizationalUnits", this.hasOrganizationalUnits() ? this.organizationalUnits() : null).add("AllOrganizationalUnitsEnabled", (Object)this.allOrganizationalUnitsEnabled()).add("ExcludeSpecifiedOrganizationalUnits", (Object)this.excludeSpecifiedOrganizationalUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnits()));
            }
            case "AllOrganizationalUnitsEnabled": {
                return Optional.ofNullable(clazz.cast(this.allOrganizationalUnitsEnabled()));
            }
            case "ExcludeSpecifiedOrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.excludeSpecifiedOrganizationalUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationalUnitScope, T> g) {
        return obj -> g.apply((OrganizationalUnitScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> organizationalUnits = DefaultSdkAutoConstructList.getInstance();
        private Boolean allOrganizationalUnitsEnabled;
        private Boolean excludeSpecifiedOrganizationalUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationalUnitScope model) {
            this.organizationalUnits(model.organizationalUnits);
            this.allOrganizationalUnitsEnabled(model.allOrganizationalUnitsEnabled);
            this.excludeSpecifiedOrganizationalUnits(model.excludeSpecifiedOrganizationalUnits);
        }

        public final Collection<String> getOrganizationalUnits() {
            if (this.organizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnits;
        }

        public final void setOrganizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitIdListCopier.copy(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitIdListCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(String ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public final Boolean getAllOrganizationalUnitsEnabled() {
            return this.allOrganizationalUnitsEnabled;
        }

        public final void setAllOrganizationalUnitsEnabled(Boolean allOrganizationalUnitsEnabled) {
            this.allOrganizationalUnitsEnabled = allOrganizationalUnitsEnabled;
        }

        @Override
        public final Builder allOrganizationalUnitsEnabled(Boolean allOrganizationalUnitsEnabled) {
            this.allOrganizationalUnitsEnabled = allOrganizationalUnitsEnabled;
            return this;
        }

        public final Boolean getExcludeSpecifiedOrganizationalUnits() {
            return this.excludeSpecifiedOrganizationalUnits;
        }

        public final void setExcludeSpecifiedOrganizationalUnits(Boolean excludeSpecifiedOrganizationalUnits) {
            this.excludeSpecifiedOrganizationalUnits = excludeSpecifiedOrganizationalUnits;
        }

        @Override
        public final Builder excludeSpecifiedOrganizationalUnits(Boolean excludeSpecifiedOrganizationalUnits) {
            this.excludeSpecifiedOrganizationalUnits = excludeSpecifiedOrganizationalUnits;
            return this;
        }

        public OrganizationalUnitScope build() {
            return new OrganizationalUnitScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationalUnitScope> {
        public Builder organizationalUnits(Collection<String> var1);

        public Builder organizationalUnits(String ... var1);

        public Builder allOrganizationalUnitsEnabled(Boolean var1);

        public Builder excludeSpecifiedOrganizationalUnits(Boolean var1);
    }
}

