/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.FisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTargetAccountConfigurationRequest
extends FisRequest
implements ToCopyableBuilder<Builder, UpdateTargetAccountConfigurationRequest> {
    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentTemplateId").getter(UpdateTargetAccountConfigurationRequest.getter(UpdateTargetAccountConfigurationRequest::experimentTemplateId)).setter(UpdateTargetAccountConfigurationRequest.setter(Builder::experimentTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(UpdateTargetAccountConfigurationRequest.getter(UpdateTargetAccountConfigurationRequest::accountId)).setter(UpdateTargetAccountConfigurationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateTargetAccountConfigurationRequest.getter(UpdateTargetAccountConfigurationRequest::roleArn)).setter(UpdateTargetAccountConfigurationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateTargetAccountConfigurationRequest.getter(UpdateTargetAccountConfigurationRequest::description)).setter(UpdateTargetAccountConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_TEMPLATE_ID_FIELD, ACCOUNT_ID_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", EXPERIMENT_TEMPLATE_ID_FIELD);
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
        }
    });
    private final String experimentTemplateId;
    private final String accountId;
    private final String roleArn;
    private final String description;

    private UpdateTargetAccountConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.experimentTemplateId = builder.experimentTemplateId;
        this.accountId = builder.accountId;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
    }

    public final String experimentTemplateId() {
        return this.experimentTemplateId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTargetAccountConfigurationRequest)) {
            return false;
        }
        UpdateTargetAccountConfigurationRequest other = (UpdateTargetAccountConfigurationRequest)((Object)obj);
        return Objects.equals(this.experimentTemplateId(), other.experimentTemplateId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTargetAccountConfigurationRequest").add("ExperimentTemplateId", (Object)this.experimentTemplateId()).add("AccountId", (Object)this.accountId()).add("RoleArn", (Object)this.roleArn()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experimentTemplateId": {
                return Optional.ofNullable(clazz.cast(this.experimentTemplateId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTargetAccountConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateTargetAccountConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisRequest.BuilderImpl
    implements Builder {
        private String experimentTemplateId;
        private String accountId;
        private String roleArn;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTargetAccountConfigurationRequest model) {
            super(model);
            this.experimentTemplateId(model.experimentTemplateId);
            this.accountId(model.accountId);
            this.roleArn(model.roleArn);
            this.description(model.description);
        }

        public final String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTargetAccountConfigurationRequest build() {
            return new UpdateTargetAccountConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTargetAccountConfigurationRequest> {
        public Builder experimentTemplateId(String var1);

        public Builder accountId(String var1);

        public Builder roleArn(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

