/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateCloudWatchLogsLogConfigurationInput;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateS3LogConfigurationInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExperimentTemplateLogConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateExperimentTemplateLogConfigurationInput> {
    private static final SdkField<ExperimentTemplateCloudWatchLogsLogConfigurationInput> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogsConfiguration").getter(UpdateExperimentTemplateLogConfigurationInput.getter(UpdateExperimentTemplateLogConfigurationInput::cloudWatchLogsConfiguration)).setter(UpdateExperimentTemplateLogConfigurationInput.setter(Builder::cloudWatchLogsConfiguration)).constructor(ExperimentTemplateCloudWatchLogsLogConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsConfiguration").build()}).build();
    private static final SdkField<ExperimentTemplateS3LogConfigurationInput> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Configuration").getter(UpdateExperimentTemplateLogConfigurationInput.getter(UpdateExperimentTemplateLogConfigurationInput::s3Configuration)).setter(UpdateExperimentTemplateLogConfigurationInput.setter(Builder::s3Configuration)).constructor(ExperimentTemplateS3LogConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()}).build();
    private static final SdkField<Integer> LOG_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("logSchemaVersion").getter(UpdateExperimentTemplateLogConfigurationInput.getter(UpdateExperimentTemplateLogConfigurationInput::logSchemaVersion)).setter(UpdateExperimentTemplateLogConfigurationInput.setter(Builder::logSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSchemaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, LOG_SCHEMA_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cloudWatchLogsConfiguration", CLOUD_WATCH_LOGS_CONFIGURATION_FIELD);
            this.put("s3Configuration", S3_CONFIGURATION_FIELD);
            this.put("logSchemaVersion", LOG_SCHEMA_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration;
    private final ExperimentTemplateS3LogConfigurationInput s3Configuration;
    private final Integer logSchemaVersion;

    private UpdateExperimentTemplateLogConfigurationInput(BuilderImpl builder) {
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.logSchemaVersion = builder.logSchemaVersion;
    }

    public final ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public final ExperimentTemplateS3LogConfigurationInput s3Configuration() {
        return this.s3Configuration;
    }

    public final Integer logSchemaVersion() {
        return this.logSchemaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSchemaVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateLogConfigurationInput)) {
            return false;
        }
        UpdateExperimentTemplateLogConfigurationInput other = (UpdateExperimentTemplateLogConfigurationInput)obj;
        return Objects.equals(this.cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.logSchemaVersion(), other.logSchemaVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateExperimentTemplateLogConfigurationInput").add("CloudWatchLogsConfiguration", (Object)this.cloudWatchLogsConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).add("LogSchemaVersion", (Object)this.logSchemaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
            case "s3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "logSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.logSchemaVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentTemplateLogConfigurationInput, T> g) {
        return obj -> g.apply((UpdateExperimentTemplateLogConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration;
        private ExperimentTemplateS3LogConfigurationInput s3Configuration;
        private Integer logSchemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentTemplateLogConfigurationInput model) {
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            this.s3Configuration(model.s3Configuration);
            this.logSchemaVersion(model.logSchemaVersion);
        }

        public final ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final ExperimentTemplateS3LogConfigurationInput.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(ExperimentTemplateS3LogConfigurationInput.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(ExperimentTemplateS3LogConfigurationInput s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final Integer getLogSchemaVersion() {
            return this.logSchemaVersion;
        }

        public final void setLogSchemaVersion(Integer logSchemaVersion) {
            this.logSchemaVersion = logSchemaVersion;
        }

        @Override
        public final Builder logSchemaVersion(Integer logSchemaVersion) {
            this.logSchemaVersion = logSchemaVersion;
            return this;
        }

        public UpdateExperimentTemplateLogConfigurationInput build() {
            return new UpdateExperimentTemplateLogConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateExperimentTemplateLogConfigurationInput> {
        public Builder cloudWatchLogsConfiguration(ExperimentTemplateCloudWatchLogsLogConfigurationInput var1);

        default public Builder cloudWatchLogsConfiguration(Consumer<ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder> cloudWatchLogsConfiguration) {
            return this.cloudWatchLogsConfiguration((ExperimentTemplateCloudWatchLogsLogConfigurationInput)((ExperimentTemplateCloudWatchLogsLogConfigurationInput.Builder)ExperimentTemplateCloudWatchLogsLogConfigurationInput.builder().applyMutation(cloudWatchLogsConfiguration)).build());
        }

        public Builder s3Configuration(ExperimentTemplateS3LogConfigurationInput var1);

        default public Builder s3Configuration(Consumer<ExperimentTemplateS3LogConfigurationInput.Builder> s3Configuration) {
            return this.s3Configuration((ExperimentTemplateS3LogConfigurationInput)((ExperimentTemplateS3LogConfigurationInput.Builder)ExperimentTemplateS3LogConfigurationInput.builder().applyMutation(s3Configuration)).build());
        }

        public Builder logSchemaVersion(Integer var1);
    }
}

