/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupMembershipStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionGroupByUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionGroupByUser> {
    private static final SdkField<String> PERMISSION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionGroupId").getter(PermissionGroupByUser.getter(PermissionGroupByUser::permissionGroupId)).setter(PermissionGroupByUser.setter(Builder::permissionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PermissionGroupByUser.getter(PermissionGroupByUser::name)).setter(PermissionGroupByUser.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipStatus").getter(PermissionGroupByUser.getter(PermissionGroupByUser::membershipStatusAsString)).setter(PermissionGroupByUser.setter(Builder::membershipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUP_ID_FIELD, NAME_FIELD, MEMBERSHIP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("permissionGroupId", PERMISSION_GROUP_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String permissionGroupId;
    private final String name;
    private final String membershipStatus;

    private PermissionGroupByUser(BuilderImpl builder) {
        this.permissionGroupId = builder.permissionGroupId;
        this.name = builder.name;
        this.membershipStatus = builder.membershipStatus;
    }

    public final String permissionGroupId() {
        return this.permissionGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final PermissionGroupMembershipStatus membershipStatus() {
        return PermissionGroupMembershipStatus.fromValue(this.membershipStatus);
    }

    public final String membershipStatusAsString() {
        return this.membershipStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroupByUser)) {
            return false;
        }
        PermissionGroupByUser other = (PermissionGroupByUser)obj;
        return Objects.equals(this.permissionGroupId(), other.permissionGroupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.membershipStatusAsString(), other.membershipStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionGroupByUser").add("PermissionGroupId", (Object)this.permissionGroupId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("MembershipStatus", (Object)this.membershipStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionGroupId": {
                return Optional.ofNullable(clazz.cast(this.permissionGroupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "membershipStatus": {
                return Optional.ofNullable(clazz.cast(this.membershipStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PermissionGroupByUser, T> g) {
        return obj -> g.apply((PermissionGroupByUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permissionGroupId;
        private String name;
        private String membershipStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionGroupByUser model) {
            this.permissionGroupId(model.permissionGroupId);
            this.name(model.name);
            this.membershipStatus(model.membershipStatus);
        }

        public final String getPermissionGroupId() {
            return this.permissionGroupId;
        }

        public final void setPermissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
        }

        @Override
        public final Builder permissionGroupId(String permissionGroupId) {
            this.permissionGroupId = permissionGroupId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMembershipStatus() {
            return this.membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(PermissionGroupMembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public PermissionGroupByUser build() {
            return new PermissionGroupByUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionGroupByUser> {
        public Builder permissionGroupId(String var1);

        public Builder name(String var1);

        public Builder membershipStatus(String var1);

        public Builder membershipStatus(PermissionGroupMembershipStatus var1);
    }
}

