/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventBusResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, UpdateEventBusResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateEventBusResponse.getter(UpdateEventBusResponse::arn)).setter(UpdateEventBusResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEventBusResponse.getter(UpdateEventBusResponse::name)).setter(UpdateEventBusResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(UpdateEventBusResponse.getter(UpdateEventBusResponse::kmsKeyIdentifier)).setter(UpdateEventBusResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEventBusResponse.getter(UpdateEventBusResponse::description)).setter(UpdateEventBusResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(UpdateEventBusResponse.getter(UpdateEventBusResponse::deadLetterConfig)).setter(UpdateEventBusResponse.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, KMS_KEY_IDENTIFIER_FIELD, DESCRIPTION_FIELD, DEAD_LETTER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        }
    });
    private final String arn;
    private final String name;
    private final String kmsKeyIdentifier;
    private final String description;
    private final DeadLetterConfig deadLetterConfig;

    private UpdateEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.description = builder.description;
        this.deadLetterConfig = builder.deadLetterConfig;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventBusResponse)) {
            return false;
        }
        UpdateEventBusResponse other = (UpdateEventBusResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventBusResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("Description", (Object)this.description()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventBusResponse, T> g) {
        return obj -> g.apply((UpdateEventBusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String kmsKeyIdentifier;
        private String description;
        private DeadLetterConfig deadLetterConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventBusResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.description(model.description);
            this.deadLetterConfig(model.deadLetterConfig);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        @Override
        public UpdateEventBusResponse build() {
            return new UpdateEventBusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventBusResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder description(String var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }
    }
}

