/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesResponse;

public class ListIdNamespacesIterable
implements SdkIterable<ListIdNamespacesResponse> {
    private final EntityResolutionClient client;
    private final ListIdNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdNamespacesIterable(EntityResolutionClient client, ListIdNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdNamespacesResponseFetcher();
    }

    public Iterator<ListIdNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdNamespaceSummary> idNamespaceSummaries() {
        Function<ListIdNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.idNamespaceSummaries() != null) {
                return response.idNamespaceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdNamespacesResponseFetcher
    implements SyncPageFetcher<ListIdNamespacesResponse> {
        private ListIdNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdNamespacesResponse nextPage(ListIdNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListIdNamespacesIterable.this.client.listIdNamespaces(ListIdNamespacesIterable.this.firstRequest);
            }
            return ListIdNamespacesIterable.this.client.listIdNamespaces((ListIdNamespacesRequest)((Object)ListIdNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

