/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.RuleMatchingKeysListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<List<String>> MATCHING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchingKeys").getter(Rule.getter(Rule::matchingKeys)).setter(Rule.setter(Builder::matchingKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchingKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(Rule.getter(Rule::ruleName)).setter(Rule.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHING_KEYS_FIELD, RULE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("matchingKeys", MATCHING_KEYS_FIELD);
            this.put("ruleName", RULE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> matchingKeys;
    private final String ruleName;

    private Rule(BuilderImpl builder) {
        this.matchingKeys = builder.matchingKeys;
        this.ruleName = builder.ruleName;
    }

    public final boolean hasMatchingKeys() {
        return this.matchingKeys != null && !(this.matchingKeys instanceof SdkAutoConstructList);
    }

    public final List<String> matchingKeys() {
        return this.matchingKeys;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingKeys() ? this.matchingKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return this.hasMatchingKeys() == other.hasMatchingKeys() && Objects.equals(this.matchingKeys(), other.matchingKeys()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("MatchingKeys", this.hasMatchingKeys() ? this.matchingKeys() : null).add("RuleName", (Object)this.ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matchingKeys": {
                return Optional.ofNullable(clazz.cast(this.matchingKeys()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchingKeys = DefaultSdkAutoConstructList.getInstance();
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.matchingKeys(model.matchingKeys);
            this.ruleName(model.ruleName);
        }

        public final Collection<String> getMatchingKeys() {
            if (this.matchingKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchingKeys;
        }

        public final void setMatchingKeys(Collection<String> matchingKeys) {
            this.matchingKeys = RuleMatchingKeysListCopier.copy(matchingKeys);
        }

        @Override
        public final Builder matchingKeys(Collection<String> matchingKeys) {
            this.matchingKeys = RuleMatchingKeysListCopier.copy(matchingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingKeys(String ... matchingKeys) {
            this.matchingKeys(Arrays.asList(matchingKeys));
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder matchingKeys(Collection<String> var1);

        public Builder matchingKeys(String ... var1);

        public Builder ruleName(String var1);
    }
}

