/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageConfiguration> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageUri").getter(ImageConfiguration.getter(ImageConfiguration::imageUri)).setter(ImageConfiguration.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUri").build()}).build();
    private static final SdkField<String> RESOLVED_IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolvedImageDigest").getter(ImageConfiguration.getter(ImageConfiguration::resolvedImageDigest)).setter(ImageConfiguration.setter(Builder::resolvedImageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedImageDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, RESOLVED_IMAGE_DIGEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("imageUri", IMAGE_URI_FIELD);
            this.put("resolvedImageDigest", RESOLVED_IMAGE_DIGEST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final String resolvedImageDigest;

    private ImageConfiguration(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.resolvedImageDigest = builder.resolvedImageDigest;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final String resolvedImageDigest() {
        return this.resolvedImageDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedImageDigest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && Objects.equals(this.resolvedImageDigest(), other.resolvedImageDigest());
    }

    public final String toString() {
        return ToString.builder((String)"ImageConfiguration").add("ImageUri", (Object)this.imageUri()).add("ResolvedImageDigest", (Object)this.resolvedImageDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "resolvedImageDigest": {
                return Optional.ofNullable(clazz.cast(this.resolvedImageDigest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfiguration, T> g) {
        return obj -> g.apply((ImageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private String resolvedImageDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfiguration model) {
            this.imageUri(model.imageUri);
            this.resolvedImageDigest(model.resolvedImageDigest);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final String getResolvedImageDigest() {
            return this.resolvedImageDigest;
        }

        public final void setResolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
        }

        @Override
        public final Builder resolvedImageDigest(String resolvedImageDigest) {
            this.resolvedImageDigest = resolvedImageDigest;
            return this;
        }

        public ImageConfiguration build() {
            return new ImageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageConfiguration> {
        public Builder imageUri(String var1);

        public Builder resolvedImageDigest(String var1);
    }
}

