/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.TemplateParameterDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateParameterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateParameterConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TemplateParameterConfiguration.getter(TemplateParameterConfiguration::typeAsString)).setter(TemplateParameterConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(TemplateParameterConfiguration.getter(TemplateParameterConfiguration::defaultValue)).setter(TemplateParameterConfiguration.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("defaultValue", DEFAULT_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String defaultValue;

    private TemplateParameterConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
    }

    public final TemplateParameterDataType type() {
        return TemplateParameterDataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameterConfiguration)) {
            return false;
        }
        TemplateParameterConfiguration other = (TemplateParameterConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateParameterConfiguration").add("Type", (Object)this.typeAsString()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateParameterConfiguration, T> g) {
        return obj -> g.apply((TemplateParameterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameterConfiguration model) {
            this.type(model.type);
            this.defaultValue(model.defaultValue);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TemplateParameterDataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TemplateParameterConfiguration build() {
            return new TemplateParameterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateParameterConfiguration> {
        public Builder type(String var1);

        public Builder type(TemplateParameterDataType var1);

        public Builder defaultValue(String var1);
    }
}

