/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Preset;
import software.amazon.awssdk.services.elastictranscoder.model.PresetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPresetsResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, ListPresetsResponse> {
    private static final SdkField<List<Preset>> PRESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Presets").getter(ListPresetsResponse.getter(ListPresetsResponse::presets)).setter(ListPresetsResponse.setter(Builder::presets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Presets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Preset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListPresetsResponse.getter(ListPresetsResponse::nextPageToken)).setter(ListPresetsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESETS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Presets", PRESETS_FIELD);
            this.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<Preset> presets;
    private final String nextPageToken;

    private ListPresetsResponse(BuilderImpl builder) {
        super(builder);
        this.presets = builder.presets;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasPresets() {
        return this.presets != null && !(this.presets instanceof SdkAutoConstructList);
    }

    public final List<Preset> presets() {
        return this.presets;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPresets() ? this.presets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResponse)) {
            return false;
        }
        ListPresetsResponse other = (ListPresetsResponse)((Object)obj);
        return this.hasPresets() == other.hasPresets() && Objects.equals(this.presets(), other.presets()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPresetsResponse").add("Presets", this.hasPresets() ? this.presets() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Presets": {
                return Optional.ofNullable(clazz.cast(this.presets()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPresetsResponse, T> g) {
        return obj -> g.apply((ListPresetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private List<Preset> presets = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsResponse model) {
            super(model);
            this.presets(model.presets);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<Preset.Builder> getPresets() {
            List<Preset.Builder> result = PresetsCopier.copyToBuilder(this.presets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPresets(Collection<Preset.BuilderImpl> presets) {
            this.presets = PresetsCopier.copyFromBuilder(presets);
        }

        @Override
        public final Builder presets(Collection<Preset> presets) {
            this.presets = PresetsCopier.copy(presets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Preset ... presets) {
            this.presets(Arrays.asList(presets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Consumer<Preset.Builder> ... presets) {
            this.presets(Stream.of(presets).map(c -> (Preset)((Preset.Builder)Preset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListPresetsResponse build() {
            return new ListPresetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPresetsResponse> {
        public Builder presets(Collection<Preset> var1);

        public Builder presets(Preset ... var1);

        public Builder presets(Consumer<Preset.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

