/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutput;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobOutputsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylist;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobPlaylistsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.JobInput;
import software.amazon.awssdk.services.elastictranscoder.model.JobInputsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.UserMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends ElasticTranscoderRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineId").getter(CreateJobRequest.getter(CreateJobRequest::pipelineId)).setter(CreateJobRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineId").build()}).build();
    private static final SdkField<JobInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(CreateJobRequest.getter(CreateJobRequest::input)).setter(CreateJobRequest.setter(Builder::input)).constructor(JobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<List<JobInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(CreateJobRequest.getter(CreateJobRequest::inputs)).setter(CreateJobRequest.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CreateJobOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(CreateJobRequest.getter(CreateJobRequest::output)).setter(CreateJobRequest.setter(Builder::output)).constructor(CreateJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<List<CreateJobOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(CreateJobRequest.getter(CreateJobRequest::outputs)).setter(CreateJobRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputKeyPrefix").getter(CreateJobRequest.getter(CreateJobRequest::outputKeyPrefix)).setter(CreateJobRequest.setter(Builder::outputKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeyPrefix").build()}).build();
    private static final SdkField<List<CreateJobPlaylist>> PLAYLISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Playlists").getter(CreateJobRequest.getter(CreateJobRequest::playlists)).setter(CreateJobRequest.setter(Builder::playlists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Playlists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateJobPlaylist::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserMetadata").getter(CreateJobRequest.getter(CreateJobRequest::userMetadata)).setter(CreateJobRequest.setter(Builder::userMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, INPUT_FIELD, INPUTS_FIELD, OUTPUT_FIELD, OUTPUTS_FIELD, OUTPUT_KEY_PREFIX_FIELD, PLAYLISTS_FIELD, USER_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PipelineId", PIPELINE_ID_FIELD);
            this.put("Input", INPUT_FIELD);
            this.put("Inputs", INPUTS_FIELD);
            this.put("Output", OUTPUT_FIELD);
            this.put("Outputs", OUTPUTS_FIELD);
            this.put("OutputKeyPrefix", OUTPUT_KEY_PREFIX_FIELD);
            this.put("Playlists", PLAYLISTS_FIELD);
            this.put("UserMetadata", USER_METADATA_FIELD);
        }
    });
    private final String pipelineId;
    private final JobInput input;
    private final List<JobInput> inputs;
    private final CreateJobOutput output;
    private final List<CreateJobOutput> outputs;
    private final String outputKeyPrefix;
    private final List<CreateJobPlaylist> playlists;
    private final Map<String, String> userMetadata;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.input = builder.input;
        this.inputs = builder.inputs;
        this.output = builder.output;
        this.outputs = builder.outputs;
        this.outputKeyPrefix = builder.outputKeyPrefix;
        this.playlists = builder.playlists;
        this.userMetadata = builder.userMetadata;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final JobInput input() {
        return this.input;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<JobInput> inputs() {
        return this.inputs;
    }

    public final CreateJobOutput output() {
        return this.output;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<CreateJobOutput> outputs() {
        return this.outputs;
    }

    public final String outputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public final boolean hasPlaylists() {
        return this.playlists != null && !(this.playlists instanceof SdkAutoConstructList);
    }

    public final List<CreateJobPlaylist> playlists() {
        return this.playlists;
    }

    public final boolean hasUserMetadata() {
        return this.userMetadata != null && !(this.userMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlaylists() ? this.playlists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMetadata() ? this.userMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.input(), other.input()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.output(), other.output()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.outputKeyPrefix(), other.outputKeyPrefix()) && this.hasPlaylists() == other.hasPlaylists() && Objects.equals(this.playlists(), other.playlists()) && this.hasUserMetadata() == other.hasUserMetadata() && Objects.equals(this.userMetadata(), other.userMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("PipelineId", (Object)this.pipelineId()).add("Input", (Object)this.input()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Output", (Object)this.output()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("OutputKeyPrefix", (Object)this.outputKeyPrefix()).add("Playlists", this.hasPlaylists() ? this.playlists() : null).add("UserMetadata", this.hasUserMetadata() ? this.userMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "OutputKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputKeyPrefix()));
            }
            case "Playlists": {
                return Optional.ofNullable(clazz.cast(this.playlists()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private JobInput input;
        private List<JobInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private CreateJobOutput output;
        private List<CreateJobOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String outputKeyPrefix;
        private List<CreateJobPlaylist> playlists = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.input(model.input);
            this.inputs(model.inputs);
            this.output(model.output);
            this.outputs(model.outputs);
            this.outputKeyPrefix(model.outputKeyPrefix);
            this.playlists(model.playlists);
            this.userMetadata(model.userMetadata);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final JobInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(JobInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(JobInput input) {
            this.input = input;
            return this;
        }

        public final List<JobInput.Builder> getInputs() {
            List<JobInput.Builder> result = JobInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<JobInput.BuilderImpl> inputs) {
            this.inputs = JobInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<JobInput> inputs) {
            this.inputs = JobInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(JobInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<JobInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (JobInput)((JobInput.Builder)JobInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreateJobOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(CreateJobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(CreateJobOutput output) {
            this.output = output;
            return this;
        }

        public final List<CreateJobOutput.Builder> getOutputs() {
            List<CreateJobOutput.Builder> result = CreateJobOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<CreateJobOutput.BuilderImpl> outputs) {
            this.outputs = CreateJobOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<CreateJobOutput> outputs) {
            this.outputs = CreateJobOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(CreateJobOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<CreateJobOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (CreateJobOutput)((CreateJobOutput.Builder)CreateJobOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutputKeyPrefix() {
            return this.outputKeyPrefix;
        }

        public final void setOutputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
        }

        @Override
        public final Builder outputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
            return this;
        }

        public final List<CreateJobPlaylist.Builder> getPlaylists() {
            List<CreateJobPlaylist.Builder> result = CreateJobPlaylistsCopier.copyToBuilder(this.playlists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlaylists(Collection<CreateJobPlaylist.BuilderImpl> playlists) {
            this.playlists = CreateJobPlaylistsCopier.copyFromBuilder(playlists);
        }

        @Override
        public final Builder playlists(Collection<CreateJobPlaylist> playlists) {
            this.playlists = CreateJobPlaylistsCopier.copy(playlists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(CreateJobPlaylist ... playlists) {
            this.playlists(Arrays.asList(playlists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Consumer<CreateJobPlaylist.Builder> ... playlists) {
            this.playlists(Stream.of(playlists).map(c -> (CreateJobPlaylist)((CreateJobPlaylist.Builder)CreateJobPlaylist.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getUserMetadata() {
            if (this.userMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userMetadata;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticTranscoderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder pipelineId(String var1);

        public Builder input(JobInput var1);

        default public Builder input(Consumer<JobInput.Builder> input) {
            return this.input((JobInput)((JobInput.Builder)JobInput.builder().applyMutation(input)).build());
        }

        public Builder inputs(Collection<JobInput> var1);

        public Builder inputs(JobInput ... var1);

        public Builder inputs(Consumer<JobInput.Builder> ... var1);

        public Builder output(CreateJobOutput var1);

        default public Builder output(Consumer<CreateJobOutput.Builder> output) {
            return this.output((CreateJobOutput)((CreateJobOutput.Builder)CreateJobOutput.builder().applyMutation(output)).build());
        }

        public Builder outputs(Collection<CreateJobOutput> var1);

        public Builder outputs(CreateJobOutput ... var1);

        public Builder outputs(Consumer<CreateJobOutput.Builder> ... var1);

        public Builder outputKeyPrefix(String var1);

        public Builder playlists(Collection<CreateJobPlaylist> var1);

        public Builder playlists(CreateJobPlaylist ... var1);

        public Builder playlists(Consumer<CreateJobPlaylist.Builder> ... var1);

        public Builder userMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

