/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyTypeDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyTypeDescription> {
    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyTypeName").getter(PolicyTypeDescription.getter(PolicyTypeDescription::policyTypeName)).setter(PolicyTypeDescription.setter(Builder::policyTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PolicyTypeDescription.getter(PolicyTypeDescription::description)).setter(PolicyTypeDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<PolicyAttributeTypeDescription>> POLICY_ATTRIBUTE_TYPE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyAttributeTypeDescriptions").getter(PolicyTypeDescription.getter(PolicyTypeDescription::policyAttributeTypeDescriptions)).setter(PolicyTypeDescription.setter(Builder::policyAttributeTypeDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributeTypeDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyAttributeTypeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_NAME_FIELD, DESCRIPTION_FIELD, POLICY_ATTRIBUTE_TYPE_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PolicyTypeName", POLICY_TYPE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("PolicyAttributeTypeDescriptions", POLICY_ATTRIBUTE_TYPE_DESCRIPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyTypeName;
    private final String description;
    private final List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions;

    private PolicyTypeDescription(BuilderImpl builder) {
        this.policyTypeName = builder.policyTypeName;
        this.description = builder.description;
        this.policyAttributeTypeDescriptions = builder.policyAttributeTypeDescriptions;
    }

    public final String policyTypeName() {
        return this.policyTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPolicyAttributeTypeDescriptions() {
        return this.policyAttributeTypeDescriptions != null && !(this.policyAttributeTypeDescriptions instanceof SdkAutoConstructList);
    }

    public final List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions() {
        return this.policyAttributeTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyAttributeTypeDescriptions() ? this.policyAttributeTypeDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeDescription)) {
            return false;
        }
        PolicyTypeDescription other = (PolicyTypeDescription)obj;
        return Objects.equals(this.policyTypeName(), other.policyTypeName()) && Objects.equals(this.description(), other.description()) && this.hasPolicyAttributeTypeDescriptions() == other.hasPolicyAttributeTypeDescriptions() && Objects.equals(this.policyAttributeTypeDescriptions(), other.policyAttributeTypeDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyTypeDescription").add("PolicyTypeName", (Object)this.policyTypeName()).add("Description", (Object)this.description()).add("PolicyAttributeTypeDescriptions", this.hasPolicyAttributeTypeDescriptions() ? this.policyAttributeTypeDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeName": {
                return Optional.ofNullable(clazz.cast(this.policyTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PolicyAttributeTypeDescriptions": {
                return Optional.ofNullable(clazz.cast(this.policyAttributeTypeDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyTypeDescription, T> g) {
        return obj -> g.apply((PolicyTypeDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyTypeName;
        private String description;
        private List<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeDescription model) {
            this.policyTypeName(model.policyTypeName);
            this.description(model.description);
            this.policyAttributeTypeDescriptions(model.policyAttributeTypeDescriptions);
        }

        public final String getPolicyTypeName() {
            return this.policyTypeName;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PolicyAttributeTypeDescription.Builder> getPolicyAttributeTypeDescriptions() {
            List<PolicyAttributeTypeDescription.Builder> result = PolicyAttributeTypeDescriptionsCopier.copyToBuilder(this.policyAttributeTypeDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription.BuilderImpl> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copyFromBuilder(policyAttributeTypeDescriptions);
        }

        @Override
        public final Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions = PolicyAttributeTypeDescriptionsCopier.copy(policyAttributeTypeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions(Arrays.asList(policyAttributeTypeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeTypeDescriptions(Consumer<PolicyAttributeTypeDescription.Builder> ... policyAttributeTypeDescriptions) {
            this.policyAttributeTypeDescriptions(Stream.of(policyAttributeTypeDescriptions).map(c -> (PolicyAttributeTypeDescription)((PolicyAttributeTypeDescription.Builder)PolicyAttributeTypeDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PolicyTypeDescription build() {
            return new PolicyTypeDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyTypeDescription> {
        public Builder policyTypeName(String var1);

        public Builder description(String var1);

        public Builder policyAttributeTypeDescriptions(Collection<PolicyAttributeTypeDescription> var1);

        public Builder policyAttributeTypeDescriptions(PolicyAttributeTypeDescription ... var1);

        public Builder policyAttributeTypeDescriptions(Consumer<PolicyAttributeTypeDescription.Builder> ... var1);
    }
}

