/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;

public class ListPlatformVersionsIterable
implements SdkIterable<ListPlatformVersionsResponse> {
    private final ElasticBeanstalkClient client;
    private final ListPlatformVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlatformVersionsIterable(ElasticBeanstalkClient client, ListPlatformVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlatformVersionsResponseFetcher();
    }

    public Iterator<ListPlatformVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlatformSummary> platformSummaryList() {
        Function<ListPlatformVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformSummaryList() != null) {
                return response.platformSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlatformVersionsResponseFetcher
    implements SyncPageFetcher<ListPlatformVersionsResponse> {
        private ListPlatformVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlatformVersionsResponse nextPage(ListPlatformVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformVersionsIterable.this.client.listPlatformVersions(ListPlatformVersionsIterable.this.firstRequest);
            }
            return ListPlatformVersionsIterable.this.client.listPlatformVersions((ListPlatformVersionsRequest)((Object)ListPlatformVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

