/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailureType {
    UPDATE_CANCELLED("UpdateCancelled"),
    CANCELLATION_FAILED("CancellationFailed"),
    ROLLBACK_FAILED("RollbackFailed"),
    ROLLBACK_SUCCESSFUL("RollbackSuccessful"),
    INTERNAL_FAILURE("InternalFailure"),
    INVALID_ENVIRONMENT_STATE("InvalidEnvironmentState"),
    PERMISSIONS_ERROR("PermissionsError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailureType> VALUE_MAP;
    private final String value;

    private FailureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureType> knownValues() {
        EnumSet<FailureType> knownValues = EnumSet.allOf(FailureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailureType.class, FailureType::toString);
    }
}

