/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCache;

public class DescribeServerlessCachesIterable
implements SdkIterable<DescribeServerlessCachesResponse> {
    private final ElastiCacheClient client;
    private final DescribeServerlessCachesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServerlessCachesIterable(ElastiCacheClient client, DescribeServerlessCachesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeServerlessCachesResponseFetcher();
    }

    public Iterator<DescribeServerlessCachesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServerlessCache> serverlessCaches() {
        Function<DescribeServerlessCachesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverlessCaches() != null) {
                return response.serverlessCaches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServerlessCachesResponseFetcher
    implements SyncPageFetcher<DescribeServerlessCachesResponse> {
        private DescribeServerlessCachesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServerlessCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServerlessCachesResponse nextPage(DescribeServerlessCachesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServerlessCachesIterable.this.client.describeServerlessCaches(DescribeServerlessCachesIterable.this.firstRequest);
            }
            return DescribeServerlessCachesIterable.this.client.describeServerlessCaches((DescribeServerlessCachesRequest)((Object)DescribeServerlessCachesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

