/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SupportType {
    STANDARD("STANDARD"),
    EXTENDED("EXTENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SupportType> VALUE_MAP;
    private final String value;

    private SupportType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SupportType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SupportType> knownValues() {
        EnumSet<SupportType> knownValues = EnumSet.allOf(SupportType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SupportType.class, SupportType::toString);
    }
}

