/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteAccessConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteAccessConfig> {
    private static final SdkField<String> EC2_SSH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2SshKey").getter(RemoteAccessConfig.getter(RemoteAccessConfig::ec2SshKey)).setter(RemoteAccessConfig.setter(Builder::ec2SshKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SshKey").build()}).build();
    private static final SdkField<List<String>> SOURCE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceSecurityGroups").getter(RemoteAccessConfig.getter(RemoteAccessConfig::sourceSecurityGroups)).setter(RemoteAccessConfig.setter(Builder::sourceSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_SSH_KEY_FIELD, SOURCE_SECURITY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ec2SshKey", EC2_SSH_KEY_FIELD);
            this.put("sourceSecurityGroups", SOURCE_SECURITY_GROUPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ec2SshKey;
    private final List<String> sourceSecurityGroups;

    private RemoteAccessConfig(BuilderImpl builder) {
        this.ec2SshKey = builder.ec2SshKey;
        this.sourceSecurityGroups = builder.sourceSecurityGroups;
    }

    public final String ec2SshKey() {
        return this.ec2SshKey;
    }

    public final boolean hasSourceSecurityGroups() {
        return this.sourceSecurityGroups != null && !(this.sourceSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> sourceSecurityGroups() {
        return this.sourceSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SshKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceSecurityGroups() ? this.sourceSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessConfig)) {
            return false;
        }
        RemoteAccessConfig other = (RemoteAccessConfig)obj;
        return Objects.equals(this.ec2SshKey(), other.ec2SshKey()) && this.hasSourceSecurityGroups() == other.hasSourceSecurityGroups() && Objects.equals(this.sourceSecurityGroups(), other.sourceSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"RemoteAccessConfig").add("Ec2SshKey", (Object)this.ec2SshKey()).add("SourceSecurityGroups", this.hasSourceSecurityGroups() ? this.sourceSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2SshKey": {
                return Optional.ofNullable(clazz.cast(this.ec2SshKey()));
            }
            case "sourceSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.sourceSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccessConfig, T> g) {
        return obj -> g.apply((RemoteAccessConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2SshKey;
        private List<String> sourceSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessConfig model) {
            this.ec2SshKey(model.ec2SshKey);
            this.sourceSecurityGroups(model.sourceSecurityGroups);
        }

        public final String getEc2SshKey() {
            return this.ec2SshKey;
        }

        public final void setEc2SshKey(String ec2SshKey) {
            this.ec2SshKey = ec2SshKey;
        }

        @Override
        public final Builder ec2SshKey(String ec2SshKey) {
            this.ec2SshKey = ec2SshKey;
            return this;
        }

        public final Collection<String> getSourceSecurityGroups() {
            if (this.sourceSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceSecurityGroups;
        }

        public final void setSourceSecurityGroups(Collection<String> sourceSecurityGroups) {
            this.sourceSecurityGroups = StringListCopier.copy(sourceSecurityGroups);
        }

        @Override
        public final Builder sourceSecurityGroups(Collection<String> sourceSecurityGroups) {
            this.sourceSecurityGroups = StringListCopier.copy(sourceSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSecurityGroups(String ... sourceSecurityGroups) {
            this.sourceSecurityGroups(Arrays.asList(sourceSecurityGroups));
            return this;
        }

        public RemoteAccessConfig build() {
            return new RemoteAccessConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteAccessConfig> {
        public Builder ec2SshKey(String var1);

        public Builder sourceSecurityGroups(Collection<String> var1);

        public Builder sourceSecurityGroups(String ... var1);
    }
}

