/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;

public class DescribeFileSystemsIterable
implements SdkIterable<DescribeFileSystemsResponse> {
    private final EfsClient client;
    private final DescribeFileSystemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFileSystemsIterable(EfsClient client, DescribeFileSystemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFileSystemsResponseFetcher();
    }

    public Iterator<DescribeFileSystemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FileSystemDescription> fileSystems() {
        Function<DescribeFileSystemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileSystems() != null) {
                return response.fileSystems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFileSystemsResponseFetcher
    implements SyncPageFetcher<DescribeFileSystemsResponse> {
        private DescribeFileSystemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFileSystemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeFileSystemsResponse nextPage(DescribeFileSystemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFileSystemsIterable.this.client.describeFileSystems(DescribeFileSystemsIterable.this.firstRequest);
            }
            return DescribeFileSystemsIterable.this.client.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

