/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.FirelensConfigurationOptionsMapCopier;
import software.amazon.awssdk.services.ecs.model.FirelensConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirelensConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirelensConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FirelensConfiguration.getter(FirelensConfiguration::typeAsString)).setter(FirelensConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("options").getter(FirelensConfiguration.getter(FirelensConfiguration::options)).setter(FirelensConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("options", OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Map<String, String> options;

    private FirelensConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.options = builder.options;
    }

    public final FirelensConfigurationType type() {
        return FirelensConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirelensConfiguration)) {
            return false;
        }
        FirelensConfiguration other = (FirelensConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"FirelensConfiguration").add("Type", (Object)this.typeAsString()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FirelensConfiguration, T> g) {
        return obj -> g.apply((FirelensConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirelensConfiguration model) {
            this.type(model.type);
            this.options(model.options);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FirelensConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, String> getOptions() {
            if (this.options instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = FirelensConfigurationOptionsMapCopier.copy(options);
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = FirelensConfigurationOptionsMapCopier.copy(options);
            return this;
        }

        public FirelensConfiguration build() {
            return new FirelensConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirelensConfiguration> {
        public Builder type(String var1);

        public Builder type(FirelensConfigurationType var1);

        public Builder options(Map<String, String> var1);
    }
}

