/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ClusterField;
import software.amazon.awssdk.services.ecs.model.ClusterFieldListCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClustersRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeClustersRequest> {
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusters").getter(DescribeClustersRequest.getter(DescribeClustersRequest::clusters)).setter(DescribeClustersRequest.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("include").getter(DescribeClustersRequest.getter(DescribeClustersRequest::includeAsStrings)).setter(DescribeClustersRequest.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTERS_FIELD, INCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusters", CLUSTERS_FIELD);
            this.put("include", INCLUDE_FIELD);
        }
    });
    private final List<String> clusters;
    private final List<String> include;

    private DescribeClustersRequest(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.include = builder.include;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<String> clusters() {
        return this.clusters;
    }

    public final List<ClusterField> include() {
        return ClusterFieldListCopier.copyStringToEnum(this.include);
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public final List<String> includeAsStrings() {
        return this.include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.includeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersRequest)) {
            return false;
        }
        DescribeClustersRequest other = (DescribeClustersRequest)((Object)obj);
        return this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && this.hasInclude() == other.hasInclude() && Objects.equals(this.includeAsStrings(), other.includeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClustersRequest").add("Clusters", this.hasClusters() ? this.clusters() : null).add("Include", this.hasInclude() ? this.includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersRequest, T> g) {
        return obj -> g.apply((DescribeClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();
        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersRequest model) {
            super(model);
            this.clusters(model.clusters);
            this.includeWithStrings(model.include);
        }

        public final Collection<String> getClusters() {
            if (this.clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final Collection<String> getInclude() {
            if (this.include instanceof SdkAutoConstructList) {
                return null;
            }
            return this.include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ClusterFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String ... include) {
            this.includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ClusterField> include) {
            this.include = ClusterFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ClusterField ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClustersRequest build() {
            return new DescribeClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClustersRequest> {
        public Builder clusters(Collection<String> var1);

        public Builder clusters(String ... var1);

        public Builder includeWithStrings(Collection<String> var1);

        public Builder includeWithStrings(String ... var1);

        public Builder include(Collection<ClusterField> var1);

        public Builder include(ClusterField ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

