/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.Scale;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTaskSetRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, CreateTaskSetRequest> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::service)).setter(CreateTaskSetRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::cluster)).setter(CreateTaskSetRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::externalId)).setter(CreateTaskSetRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::taskDefinition)).setter(CreateTaskSetRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::networkConfiguration)).setter(CreateTaskSetRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::loadBalancers)).setter(CreateTaskSetRequest.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRegistries").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::serviceRegistries)).setter(CreateTaskSetRequest.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::launchTypeAsString)).setter(CreateTaskSetRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::capacityProviderStrategy)).setter(CreateTaskSetRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::platformVersion)).setter(CreateTaskSetRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Scale> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scale").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::scale)).setter(CreateTaskSetRequest.setter(Builder::scale)).constructor(Scale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::clientToken)).setter(CreateTaskSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateTaskSetRequest.getter(CreateTaskSetRequest::tags)).setter(CreateTaskSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, CLUSTER_FIELD, EXTERNAL_ID_FIELD, TASK_DEFINITION_FIELD, NETWORK_CONFIGURATION_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, SCALE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("service", SERVICE_FIELD);
            this.put("cluster", CLUSTER_FIELD);
            this.put("externalId", EXTERNAL_ID_FIELD);
            this.put("taskDefinition", TASK_DEFINITION_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("loadBalancers", LOAD_BALANCERS_FIELD);
            this.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
            this.put("launchType", LAUNCH_TYPE_FIELD);
            this.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
            this.put("platformVersion", PLATFORM_VERSION_FIELD);
            this.put("scale", SCALE_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String service;
    private final String cluster;
    private final String externalId;
    private final String taskDefinition;
    private final NetworkConfiguration networkConfiguration;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final String launchType;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String platformVersion;
    private final Scale scale;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateTaskSetRequest(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.cluster = builder.cluster;
        this.externalId = builder.externalId;
        this.taskDefinition = builder.taskDefinition;
        this.networkConfiguration = builder.networkConfiguration;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.scale = builder.scale;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String service() {
        return this.service;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public final boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public final List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final Scale scale() {
        return this.scale;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRegistries() ? this.serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskSetRequest)) {
            return false;
        }
        CreateTaskSetRequest other = (CreateTaskSetRequest)((Object)obj);
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && this.hasServiceRegistries() == other.hasServiceRegistries() && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.scale(), other.scale()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTaskSetRequest").add("Service", (Object)this.service()).add("Cluster", (Object)this.cluster()).add("ExternalId", (Object)this.externalId()).add("TaskDefinition", (Object)this.taskDefinition()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("ServiceRegistries", this.hasServiceRegistries() ? this.serviceRegistries() : null).add("LaunchType", (Object)this.launchTypeAsString()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("PlatformVersion", (Object)this.platformVersion()).add("Scale", (Object)this.scale()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskSetRequest, T> g) {
        return obj -> g.apply((CreateTaskSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String service;
        private String cluster;
        private String externalId;
        private String taskDefinition;
        private NetworkConfiguration networkConfiguration;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private String launchType;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private Scale scale;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskSetRequest model) {
            super(model);
            this.service(model.service);
            this.cluster(model.cluster);
            this.externalId(model.externalId);
            this.taskDefinition(model.taskDefinition);
            this.networkConfiguration(model.networkConfiguration);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.launchType(model.launchType);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.platformVersion(model.platformVersion);
            this.scale(model.scale);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final Scale.Builder getScale() {
            return this.scale != null ? this.scale.toBuilder() : null;
        }

        public final void setScale(Scale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        @Override
        public final Builder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTaskSetRequest build() {
            return new CreateTaskSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTaskSetRequest> {
        public Builder service(String var1);

        public Builder cluster(String var1);

        public Builder externalId(String var1);

        public Builder taskDefinition(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder scale(Scale var1);

        default public Builder scale(Consumer<Scale.Builder> scale) {
            return this.scale((Scale)((Scale.Builder)Scale.builder().applyMutation(scale)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

