/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DataResponse;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse;

public class GetAwsNetworkPerformanceDataIterable
implements SdkIterable<GetAwsNetworkPerformanceDataResponse> {
    private final Ec2Client client;
    private final GetAwsNetworkPerformanceDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAwsNetworkPerformanceDataIterable(Ec2Client client, GetAwsNetworkPerformanceDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAwsNetworkPerformanceDataResponseFetcher();
    }

    public Iterator<GetAwsNetworkPerformanceDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataResponse> dataResponses() {
        Function<GetAwsNetworkPerformanceDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataResponses() != null) {
                return response.dataResponses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAwsNetworkPerformanceDataResponseFetcher
    implements SyncPageFetcher<GetAwsNetworkPerformanceDataResponse> {
        private GetAwsNetworkPerformanceDataResponseFetcher() {
        }

        public boolean hasNextPage(GetAwsNetworkPerformanceDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAwsNetworkPerformanceDataResponse nextPage(GetAwsNetworkPerformanceDataResponse previousPage) {
            if (previousPage == null) {
                return GetAwsNetworkPerformanceDataIterable.this.client.getAwsNetworkPerformanceData(GetAwsNetworkPerformanceDataIterable.this.firstRequest);
            }
            return GetAwsNetworkPerformanceDataIterable.this.client.getAwsNetworkPerformanceData((GetAwsNetworkPerformanceDataRequest)((Object)GetAwsNetworkPerformanceDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

