/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRoute> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(TransitGatewayRoute.getter(TransitGatewayRoute::destinationCidrBlock)).setter(TransitGatewayRoute.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(TransitGatewayRoute.getter(TransitGatewayRoute::prefixListId)).setter(TransitGatewayRoute.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableAnnouncementId").getter(TransitGatewayRoute.getter(TransitGatewayRoute::transitGatewayRouteTableAnnouncementId)).setter(TransitGatewayRoute.setter(Builder::transitGatewayRouteTableAnnouncementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableAnnouncementId").unmarshallLocationName("transitGatewayRouteTableAnnouncementId").build()}).build();
    private static final SdkField<List<TransitGatewayRouteAttachment>> TRANSIT_GATEWAY_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayAttachments").getter(TransitGatewayRoute.getter(TransitGatewayRoute::transitGatewayAttachments)).setter(TransitGatewayRoute.setter(Builder::transitGatewayAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachments").unmarshallLocationName("transitGatewayAttachments").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRouteAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TransitGatewayRoute.getter(TransitGatewayRoute::typeAsString)).setter(TransitGatewayRoute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayRoute.getter(TransitGatewayRoute::stateAsString)).setter(TransitGatewayRoute.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, PREFIX_LIST_ID_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENTS_FIELD, TYPE_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
            this.put("PrefixListId", PREFIX_LIST_ID_FIELD);
            this.put("TransitGatewayRouteTableAnnouncementId", TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD);
            this.put("TransitGatewayAttachments", TRANSIT_GATEWAY_ATTACHMENTS_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("State", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String destinationCidrBlock;
    private final String prefixListId;
    private final String transitGatewayRouteTableAnnouncementId;
    private final List<TransitGatewayRouteAttachment> transitGatewayAttachments;
    private final String type;
    private final String state;

    private TransitGatewayRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.prefixListId = builder.prefixListId;
        this.transitGatewayRouteTableAnnouncementId = builder.transitGatewayRouteTableAnnouncementId;
        this.transitGatewayAttachments = builder.transitGatewayAttachments;
        this.type = builder.type;
        this.state = builder.state;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String transitGatewayRouteTableAnnouncementId() {
        return this.transitGatewayRouteTableAnnouncementId;
    }

    public final boolean hasTransitGatewayAttachments() {
        return this.transitGatewayAttachments != null && !(this.transitGatewayAttachments instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRouteAttachment> transitGatewayAttachments() {
        return this.transitGatewayAttachments;
    }

    public final TransitGatewayRouteType type() {
        return TransitGatewayRouteType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TransitGatewayRouteState state() {
        return TransitGatewayRouteState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableAnnouncementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayAttachments() ? this.transitGatewayAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRoute)) {
            return false;
        }
        TransitGatewayRoute other = (TransitGatewayRoute)obj;
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.transitGatewayRouteTableAnnouncementId(), other.transitGatewayRouteTableAnnouncementId()) && this.hasTransitGatewayAttachments() == other.hasTransitGatewayAttachments() && Objects.equals(this.transitGatewayAttachments(), other.transitGatewayAttachments()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayRoute").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("PrefixListId", (Object)this.prefixListId()).add("TransitGatewayRouteTableAnnouncementId", (Object)this.transitGatewayRouteTableAnnouncementId()).add("TransitGatewayAttachments", this.hasTransitGatewayAttachments() ? this.transitGatewayAttachments() : null).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "TransitGatewayRouteTableAnnouncementId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableAnnouncementId()));
            }
            case "TransitGatewayAttachments": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachments()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRoute, T> g) {
        return obj -> g.apply((TransitGatewayRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String prefixListId;
        private String transitGatewayRouteTableAnnouncementId;
        private List<TransitGatewayRouteAttachment> transitGatewayAttachments = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRoute model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.prefixListId(model.prefixListId);
            this.transitGatewayRouteTableAnnouncementId(model.transitGatewayRouteTableAnnouncementId);
            this.transitGatewayAttachments(model.transitGatewayAttachments);
            this.type(model.type);
            this.state(model.state);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getTransitGatewayRouteTableAnnouncementId() {
            return this.transitGatewayRouteTableAnnouncementId;
        }

        public final void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
            return this;
        }

        public final List<TransitGatewayRouteAttachment.Builder> getTransitGatewayAttachments() {
            List<TransitGatewayRouteAttachment.Builder> result = TransitGatewayRouteAttachmentListCopier.copyToBuilder(this.transitGatewayAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayAttachments(Collection<TransitGatewayRouteAttachment.BuilderImpl> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayRouteAttachmentListCopier.copyFromBuilder(transitGatewayAttachments);
        }

        @Override
        public final Builder transitGatewayAttachments(Collection<TransitGatewayRouteAttachment> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayRouteAttachmentListCopier.copy(transitGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayAttachments(TransitGatewayRouteAttachment ... transitGatewayAttachments) {
            this.transitGatewayAttachments(Arrays.asList(transitGatewayAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayAttachments(Consumer<TransitGatewayRouteAttachment.Builder> ... transitGatewayAttachments) {
            this.transitGatewayAttachments(Stream.of(transitGatewayAttachments).map(c -> (TransitGatewayRouteAttachment)((TransitGatewayRouteAttachment.Builder)TransitGatewayRouteAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TransitGatewayRouteType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayRouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public TransitGatewayRoute build() {
            return new TransitGatewayRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRoute> {
        public Builder destinationCidrBlock(String var1);

        public Builder prefixListId(String var1);

        public Builder transitGatewayRouteTableAnnouncementId(String var1);

        public Builder transitGatewayAttachments(Collection<TransitGatewayRouteAttachment> var1);

        public Builder transitGatewayAttachments(TransitGatewayRouteAttachment ... var1);

        public Builder transitGatewayAttachments(Consumer<TransitGatewayRouteAttachment.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(TransitGatewayRouteType var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayRouteState var1);
    }
}

