/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.KeyType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPairInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyPairInfo> {
    private static final SdkField<String> KEY_PAIR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairId").getter(KeyPairInfo.getter(KeyPairInfo::keyPairId)).setter(KeyPairInfo.setter(Builder::keyPairId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("keyPairId").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(KeyPairInfo.getter(KeyPairInfo::keyTypeAsString)).setter(KeyPairInfo.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").unmarshallLocationName("keyType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(KeyPairInfo.getter(KeyPairInfo::tags)).setter(KeyPairInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(KeyPairInfo.getter(KeyPairInfo::publicKey)).setter(KeyPairInfo.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").unmarshallLocationName("publicKey").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(KeyPairInfo.getter(KeyPairInfo::createTime)).setter(KeyPairInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(KeyPairInfo.getter(KeyPairInfo::keyName)).setter(KeyPairInfo.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFingerprint").getter(KeyPairInfo.getter(KeyPairInfo::keyFingerprint)).setter(KeyPairInfo.setter(Builder::keyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").unmarshallLocationName("keyFingerprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_ID_FIELD, KEY_TYPE_FIELD, TAGS_FIELD, PUBLIC_KEY_FIELD, CREATE_TIME_FIELD, KEY_NAME_FIELD, KEY_FINGERPRINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyPairId", KEY_PAIR_ID_FIELD);
            this.put("KeyType", KEY_TYPE_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("PublicKey", PUBLIC_KEY_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("KeyName", KEY_NAME_FIELD);
            this.put("KeyFingerprint", KEY_FINGERPRINT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String keyPairId;
    private final String keyType;
    private final List<Tag> tags;
    private final String publicKey;
    private final Instant createTime;
    private final String keyName;
    private final String keyFingerprint;

    private KeyPairInfo(BuilderImpl builder) {
        this.keyPairId = builder.keyPairId;
        this.keyType = builder.keyType;
        this.tags = builder.tags;
        this.publicKey = builder.publicKey;
        this.createTime = builder.createTime;
        this.keyName = builder.keyName;
        this.keyFingerprint = builder.keyFingerprint;
    }

    public final String keyPairId() {
        return this.keyPairId;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String keyFingerprint() {
        return this.keyFingerprint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFingerprint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo)obj;
        return Objects.equals(this.keyPairId(), other.keyPairId()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.keyFingerprint(), other.keyFingerprint());
    }

    public final String toString() {
        return ToString.builder((String)"KeyPairInfo").add("KeyPairId", (Object)this.keyPairId()).add("KeyType", (Object)this.keyTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("PublicKey", (Object)this.publicKey()).add("CreateTime", (Object)this.createTime()).add("KeyName", (Object)this.keyName()).add("KeyFingerprint", (Object)this.keyFingerprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPairId": {
                return Optional.ofNullable(clazz.cast(this.keyPairId()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "KeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.keyFingerprint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KeyPairInfo, T> g) {
        return obj -> g.apply((KeyPairInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyPairId;
        private String keyType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String publicKey;
        private Instant createTime;
        private String keyName;
        private String keyFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairInfo model) {
            this.keyPairId(model.keyPairId);
            this.keyType(model.keyType);
            this.tags(model.tags);
            this.publicKey(model.publicKey);
            this.createTime(model.createTime);
            this.keyName(model.keyName);
            this.keyFingerprint(model.keyFingerprint);
        }

        public final String getKeyPairId() {
            return this.keyPairId;
        }

        public final void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        @Override
        public final Builder keyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public KeyPairInfo build() {
            return new KeyPairInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyPairInfo> {
        public Builder keyPairId(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder publicKey(String var1);

        public Builder createTime(Instant var1);

        public Builder keyName(String var1);

        public Builder keyFingerprint(String var1);
    }
}

