/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStateChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStateChange> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceStateChange.getter(InstanceStateChange::instanceId)).setter(InstanceStateChange.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<InstanceState> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentState").getter(InstanceStateChange.getter(InstanceStateChange::currentState)).setter(InstanceStateChange.setter(Builder::currentState)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").unmarshallLocationName("currentState").build()}).build();
    private static final SdkField<InstanceState> PREVIOUS_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreviousState").getter(InstanceStateChange.getter(InstanceStateChange::previousState)).setter(InstanceStateChange.setter(Builder::previousState)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousState").unmarshallLocationName("previousState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CURRENT_STATE_FIELD, PREVIOUS_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("CurrentState", CURRENT_STATE_FIELD);
            this.put("PreviousState", PREVIOUS_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final InstanceState currentState;
    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.currentState = builder.currentState;
        this.previousState = builder.previousState;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceState currentState() {
        return this.currentState;
    }

    public final InstanceState previousState() {
        return this.previousState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentState());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.currentState(), other.currentState()) && Objects.equals(this.previousState(), other.previousState());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceStateChange").add("InstanceId", (Object)this.instanceId()).add("CurrentState", (Object)this.currentState()).add("PreviousState", (Object)this.previousState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentState()));
            }
            case "PreviousState": {
                return Optional.ofNullable(clazz.cast(this.previousState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStateChange, T> g) {
        return obj -> g.apply((InstanceStateChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private InstanceState currentState;
        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            this.instanceId(model.instanceId);
            this.currentState(model.currentState);
            this.previousState(model.previousState);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final InstanceState.Builder getCurrentState() {
            return this.currentState != null ? this.currentState.toBuilder() : null;
        }

        public final void setCurrentState(InstanceState.BuilderImpl currentState) {
            this.currentState = currentState != null ? currentState.build() : null;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final InstanceState.Builder getPreviousState() {
            return this.previousState != null ? this.previousState.toBuilder() : null;
        }

        public final void setPreviousState(InstanceState.BuilderImpl previousState) {
            this.previousState = previousState != null ? previousState.build() : null;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStateChange> {
        public Builder instanceId(String var1);

        public Builder currentState(InstanceState var1);

        default public Builder currentState(Consumer<InstanceState.Builder> currentState) {
            return this.currentState((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(currentState)).build());
        }

        public Builder previousState(InstanceState var1);

        default public Builder previousState(Consumer<InstanceState.Builder> previousState) {
            return this.previousState((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(previousState)).build());
        }
    }
}

