/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamResourceCidr;
import software.amazon.awssdk.services.ec2.model.IpamResourceCidrSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamResourceCidrsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamResourceCidrsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamResourceCidrsResponse.getter(GetIpamResourceCidrsResponse::nextToken)).setter(GetIpamResourceCidrsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamResourceCidr>> IPAM_RESOURCE_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamResourceCidrs").getter(GetIpamResourceCidrsResponse.getter(GetIpamResourceCidrsResponse::ipamResourceCidrs)).setter(GetIpamResourceCidrsResponse.setter(Builder::ipamResourceCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceCidrSet").unmarshallLocationName("ipamResourceCidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceCidr::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_RESOURCE_CIDRS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("IpamResourceCidrSet", IPAM_RESOURCE_CIDRS_FIELD);
        }
    });
    private final String nextToken;
    private final List<IpamResourceCidr> ipamResourceCidrs;

    private GetIpamResourceCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamResourceCidrs = builder.ipamResourceCidrs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamResourceCidrs() {
        return this.ipamResourceCidrs != null && !(this.ipamResourceCidrs instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceCidr> ipamResourceCidrs() {
        return this.ipamResourceCidrs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamResourceCidrs() ? this.ipamResourceCidrs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamResourceCidrsResponse)) {
            return false;
        }
        GetIpamResourceCidrsResponse other = (GetIpamResourceCidrsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamResourceCidrs() == other.hasIpamResourceCidrs() && Objects.equals(this.ipamResourceCidrs(), other.ipamResourceCidrs());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamResourceCidrsResponse").add("NextToken", (Object)this.nextToken()).add("IpamResourceCidrs", this.hasIpamResourceCidrs() ? this.ipamResourceCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamResourceCidrs": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceCidrs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamResourceCidrsResponse, T> g) {
        return obj -> g.apply((GetIpamResourceCidrsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamResourceCidr> ipamResourceCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamResourceCidrsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamResourceCidrs(model.ipamResourceCidrs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamResourceCidr.Builder> getIpamResourceCidrs() {
            List<IpamResourceCidr.Builder> result = IpamResourceCidrSetCopier.copyToBuilder(this.ipamResourceCidrs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamResourceCidrs(Collection<IpamResourceCidr.BuilderImpl> ipamResourceCidrs) {
            this.ipamResourceCidrs = IpamResourceCidrSetCopier.copyFromBuilder(ipamResourceCidrs);
        }

        @Override
        public final Builder ipamResourceCidrs(Collection<IpamResourceCidr> ipamResourceCidrs) {
            this.ipamResourceCidrs = IpamResourceCidrSetCopier.copy(ipamResourceCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceCidrs(IpamResourceCidr ... ipamResourceCidrs) {
            this.ipamResourceCidrs(Arrays.asList(ipamResourceCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceCidrs(Consumer<IpamResourceCidr.Builder> ... ipamResourceCidrs) {
            this.ipamResourceCidrs(Stream.of(ipamResourceCidrs).map(c -> (IpamResourceCidr)((IpamResourceCidr.Builder)IpamResourceCidr.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetIpamResourceCidrsResponse build() {
            return new GetIpamResourceCidrsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamResourceCidrsResponse> {
        public Builder nextToken(String var1);

        public Builder ipamResourceCidrs(Collection<IpamResourceCidr> var1);

        public Builder ipamResourceCidrs(IpamResourceCidr ... var1);

        public Builder ipamResourceCidrs(Consumer<IpamResourceCidr.Builder> ... var1);
    }
}

