/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest;
import software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequestSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityReservationBillingRequestsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityReservationBillingRequestsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityReservationBillingRequestsResponse.getter(DescribeCapacityReservationBillingRequestsResponse::nextToken)).setter(DescribeCapacityReservationBillingRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<CapacityReservationBillingRequest>> CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationBillingRequests").getter(DescribeCapacityReservationBillingRequestsResponse.getter(DescribeCapacityReservationBillingRequestsResponse::capacityReservationBillingRequests)).setter(DescribeCapacityReservationBillingRequestsResponse.setter(Builder::capacityReservationBillingRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationBillingRequestSet").unmarshallLocationName("capacityReservationBillingRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationBillingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CapacityReservationBillingRequestSet", CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD);
        }
    });
    private final String nextToken;
    private final List<CapacityReservationBillingRequest> capacityReservationBillingRequests;

    private DescribeCapacityReservationBillingRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationBillingRequests = builder.capacityReservationBillingRequests;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCapacityReservationBillingRequests() {
        return this.capacityReservationBillingRequests != null && !(this.capacityReservationBillingRequests instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationBillingRequest> capacityReservationBillingRequests() {
        return this.capacityReservationBillingRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationBillingRequests() ? this.capacityReservationBillingRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationBillingRequestsResponse)) {
            return false;
        }
        DescribeCapacityReservationBillingRequestsResponse other = (DescribeCapacityReservationBillingRequestsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCapacityReservationBillingRequests() == other.hasCapacityReservationBillingRequests() && Objects.equals(this.capacityReservationBillingRequests(), other.capacityReservationBillingRequests());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityReservationBillingRequestsResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservationBillingRequests", this.hasCapacityReservationBillingRequests() ? this.capacityReservationBillingRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservationBillingRequests": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationBillingRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationBillingRequestsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationBillingRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CapacityReservationBillingRequest> capacityReservationBillingRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationBillingRequestsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservationBillingRequests(model.capacityReservationBillingRequests);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservationBillingRequest.Builder> getCapacityReservationBillingRequests() {
            List<CapacityReservationBillingRequest.Builder> result = CapacityReservationBillingRequestSetCopier.copyToBuilder(this.capacityReservationBillingRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationBillingRequests(Collection<CapacityReservationBillingRequest.BuilderImpl> capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests = CapacityReservationBillingRequestSetCopier.copyFromBuilder(capacityReservationBillingRequests);
        }

        @Override
        public final Builder capacityReservationBillingRequests(Collection<CapacityReservationBillingRequest> capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests = CapacityReservationBillingRequestSetCopier.copy(capacityReservationBillingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationBillingRequests(CapacityReservationBillingRequest ... capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests(Arrays.asList(capacityReservationBillingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationBillingRequests(Consumer<CapacityReservationBillingRequest.Builder> ... capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests(Stream.of(capacityReservationBillingRequests).map(c -> (CapacityReservationBillingRequest)((CapacityReservationBillingRequest.Builder)CapacityReservationBillingRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationBillingRequestsResponse build() {
            return new DescribeCapacityReservationBillingRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityReservationBillingRequestsResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservationBillingRequests(Collection<CapacityReservationBillingRequest> var1);

        public Builder capacityReservationBillingRequests(CapacityReservationBillingRequest ... var1);

        public Builder capacityReservationBillingRequests(Consumer<CapacityReservationBillingRequest.Builder> ... var1);
    }
}

