/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessageListCopier;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInStatus").getter(AvailabilityZone.getter(AvailabilityZone::optInStatusAsString)).setter(AvailabilityZone.setter(Builder::optInStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").unmarshallLocationName("optInStatus").build()}).build();
    private static final SdkField<List<AvailabilityZoneMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(AvailabilityZone.getter(AvailabilityZone::messages)).setter(AvailabilityZone.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSet").unmarshallLocationName("messageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(AvailabilityZone.getter(AvailabilityZone::regionName)).setter(AvailabilityZone.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("regionName").build()}).build();
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneName").getter(AvailabilityZone.getter(AvailabilityZone::zoneName)).setter(AvailabilityZone.setter(Builder::zoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").unmarshallLocationName("zoneName").build()}).build();
    private static final SdkField<String> ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneId").getter(AvailabilityZone.getter(AvailabilityZone::zoneId)).setter(AvailabilityZone.setter(Builder::zoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId").unmarshallLocationName("zoneId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(AvailabilityZone.getter(AvailabilityZone::groupName)).setter(AvailabilityZone.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(AvailabilityZone.getter(AvailabilityZone::networkBorderGroup)).setter(AvailabilityZone.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<String> ZONE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneType").getter(AvailabilityZone.getter(AvailabilityZone::zoneType)).setter(AvailabilityZone.setter(Builder::zoneType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneType").unmarshallLocationName("zoneType").build()}).build();
    private static final SdkField<String> PARENT_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentZoneName").getter(AvailabilityZone.getter(AvailabilityZone::parentZoneName)).setter(AvailabilityZone.setter(Builder::parentZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentZoneName").unmarshallLocationName("parentZoneName").build()}).build();
    private static final SdkField<String> PARENT_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentZoneId").getter(AvailabilityZone.getter(AvailabilityZone::parentZoneId)).setter(AvailabilityZone.setter(Builder::parentZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentZoneId").unmarshallLocationName("parentZoneId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AvailabilityZone.getter(AvailabilityZone::stateAsString)).setter(AvailabilityZone.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneState").unmarshallLocationName("zoneState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_STATUS_FIELD, MESSAGES_FIELD, REGION_NAME_FIELD, ZONE_NAME_FIELD, ZONE_ID_FIELD, GROUP_NAME_FIELD, NETWORK_BORDER_GROUP_FIELD, ZONE_TYPE_FIELD, PARENT_ZONE_NAME_FIELD, PARENT_ZONE_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OptInStatus", OPT_IN_STATUS_FIELD);
            this.put("MessageSet", MESSAGES_FIELD);
            this.put("RegionName", REGION_NAME_FIELD);
            this.put("ZoneName", ZONE_NAME_FIELD);
            this.put("ZoneId", ZONE_ID_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
            this.put("ZoneType", ZONE_TYPE_FIELD);
            this.put("ParentZoneName", PARENT_ZONE_NAME_FIELD);
            this.put("ParentZoneId", PARENT_ZONE_ID_FIELD);
            this.put("ZoneState", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String optInStatus;
    private final List<AvailabilityZoneMessage> messages;
    private final String regionName;
    private final String zoneName;
    private final String zoneId;
    private final String groupName;
    private final String networkBorderGroup;
    private final String zoneType;
    private final String parentZoneName;
    private final String parentZoneId;
    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.optInStatus = builder.optInStatus;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
        this.zoneId = builder.zoneId;
        this.groupName = builder.groupName;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.zoneType = builder.zoneType;
        this.parentZoneName = builder.parentZoneName;
        this.parentZoneId = builder.parentZoneId;
        this.state = builder.state;
    }

    public final AvailabilityZoneOptInStatus optInStatus() {
        return AvailabilityZoneOptInStatus.fromValue(this.optInStatus);
    }

    public final String optInStatusAsString() {
        return this.optInStatus;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZoneMessage> messages() {
        return this.messages;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String zoneName() {
        return this.zoneName;
    }

    public final String zoneId() {
        return this.zoneId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final String zoneType() {
        return this.zoneType;
    }

    public final String parentZoneName() {
        return this.parentZoneName;
    }

    public final String parentZoneId() {
        return this.parentZoneId;
    }

    public final AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.optInStatusAsString(), other.optInStatusAsString()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.zoneName(), other.zoneName()) && Objects.equals(this.zoneId(), other.zoneId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(this.zoneType(), other.zoneType()) && Objects.equals(this.parentZoneName(), other.parentZoneName()) && Objects.equals(this.parentZoneId(), other.parentZoneId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AvailabilityZone").add("OptInStatus", (Object)this.optInStatusAsString()).add("Messages", this.hasMessages() ? this.messages() : null).add("RegionName", (Object)this.regionName()).add("ZoneName", (Object)this.zoneName()).add("ZoneId", (Object)this.zoneId()).add("GroupName", (Object)this.groupName()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("ZoneType", (Object)this.zoneType()).add("ParentZoneName", (Object)this.parentZoneName()).add("ParentZoneId", (Object)this.parentZoneId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptInStatus": {
                return Optional.ofNullable(clazz.cast(this.optInStatusAsString()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ZoneName": {
                return Optional.ofNullable(clazz.cast(this.zoneName()));
            }
            case "ZoneId": {
                return Optional.ofNullable(clazz.cast(this.zoneId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "ZoneType": {
                return Optional.ofNullable(clazz.cast(this.zoneType()));
            }
            case "ParentZoneName": {
                return Optional.ofNullable(clazz.cast(this.parentZoneName()));
            }
            case "ParentZoneId": {
                return Optional.ofNullable(clazz.cast(this.parentZoneId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optInStatus;
        private List<AvailabilityZoneMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private String regionName;
        private String zoneName;
        private String zoneId;
        private String groupName;
        private String networkBorderGroup;
        private String zoneType;
        private String parentZoneName;
        private String parentZoneId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.optInStatus(model.optInStatus);
            this.messages(model.messages);
            this.regionName(model.regionName);
            this.zoneName(model.zoneName);
            this.zoneId(model.zoneId);
            this.groupName(model.groupName);
            this.networkBorderGroup(model.networkBorderGroup);
            this.zoneType(model.zoneType);
            this.parentZoneName(model.parentZoneName);
            this.parentZoneId(model.parentZoneId);
            this.state(model.state);
        }

        public final String getOptInStatus() {
            return this.optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(AvailabilityZoneOptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final List<AvailabilityZoneMessage.Builder> getMessages() {
            List<AvailabilityZoneMessage.Builder> result = AvailabilityZoneMessageListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (AvailabilityZoneMessage)((AvailabilityZoneMessage.Builder)AvailabilityZoneMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final String getZoneId() {
            return this.zoneId;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getZoneType() {
            return this.zoneType;
        }

        public final void setZoneType(String zoneType) {
            this.zoneType = zoneType;
        }

        @Override
        public final Builder zoneType(String zoneType) {
            this.zoneType = zoneType;
            return this;
        }

        public final String getParentZoneName() {
            return this.parentZoneName;
        }

        public final void setParentZoneName(String parentZoneName) {
            this.parentZoneName = parentZoneName;
        }

        @Override
        public final Builder parentZoneName(String parentZoneName) {
            this.parentZoneName = parentZoneName;
            return this;
        }

        public final String getParentZoneId() {
            return this.parentZoneId;
        }

        public final void setParentZoneId(String parentZoneId) {
            this.parentZoneId = parentZoneId;
        }

        @Override
        public final Builder parentZoneId(String parentZoneId) {
            this.parentZoneId = parentZoneId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZone> {
        public Builder optInStatus(String var1);

        public Builder optInStatus(AvailabilityZoneOptInStatus var1);

        public Builder messages(Collection<AvailabilityZoneMessage> var1);

        public Builder messages(AvailabilityZoneMessage ... var1);

        public Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... var1);

        public Builder regionName(String var1);

        public Builder zoneName(String var1);

        public Builder zoneId(String var1);

        public Builder groupName(String var1);

        public Builder networkBorderGroup(String var1);

        public Builder zoneType(String var1);

        public Builder parentZoneName(String var1);

        public Builder parentZoneId(String var1);

        public Builder state(String var1);

        public Builder state(AvailabilityZoneState var1);
    }
}

