/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetShardIteratorRequest
extends DynamoDbStreamsRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::streamArn)).setter(GetShardIteratorRequest.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardId").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardId)).setter(GetShardIteratorRequest.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()}).build();
    private static final SdkField<String> SHARD_ITERATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShardIteratorType").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::shardIteratorTypeAsString)).setter(GetShardIteratorRequest.setter(Builder::shardIteratorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIteratorType").build()}).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SequenceNumber").getter(GetShardIteratorRequest.getter(GetShardIteratorRequest::sequenceNumber)).setter(GetShardIteratorRequest.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, SHARD_ID_FIELD, SHARD_ITERATOR_TYPE_FIELD, SEQUENCE_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StreamArn", STREAM_ARN_FIELD);
            this.put("ShardId", SHARD_ID_FIELD);
            this.put("ShardIteratorType", SHARD_ITERATOR_TYPE_FIELD);
            this.put("SequenceNumber", SEQUENCE_NUMBER_FIELD);
        }
    });
    private final String streamArn;
    private final String shardId;
    private final String shardIteratorType;
    private final String sequenceNumber;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(this.shardIteratorType);
    }

    public final String shardIteratorTypeAsString() {
        return this.shardIteratorType;
    }

    public final String sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.shardIteratorTypeAsString(), other.shardIteratorTypeAsString()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetShardIteratorRequest").add("StreamArn", (Object)this.streamArn()).add("ShardId", (Object)this.shardId()).add("ShardIteratorType", (Object)this.shardIteratorTypeAsString()).add("SequenceNumber", (Object)this.sequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ShardIteratorType": {
                return Optional.ofNullable(clazz.cast(this.shardIteratorTypeAsString()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorRequest, T> g) {
        return obj -> g.apply((GetShardIteratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbStreamsRequest.BuilderImpl
    implements Builder {
        private String streamArn;
        private String shardId;
        private String shardIteratorType;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            this.streamArn(model.streamArn);
            this.shardId(model.shardId);
            this.shardIteratorType(model.shardIteratorType);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType == null ? null : shardIteratorType.toString());
            return this;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamArn(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder sequenceNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

